/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.io;

import io.micronaut.core.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.grails.forge.application.Project;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.io.OutputUtils;
import org.grails.forge.template.Template;

public class ZipOutputHandler
implements OutputHandler {
    private final ZipArchiveOutputStream zipOutputStream;
    private final File zip;
    private final String directory;
    private final Set<String> createdDirs = new HashSet<String>();
    private final FileTime lastModified;

    public ZipOutputHandler(Project project) throws IOException {
        File baseDirectory = new File(".").getCanonicalFile();
        Path zipPath = Paths.get(baseDirectory.getPath(), project.getName() + ".zip");
        this.zip = zipPath.toAbsolutePath().normalize().toFile();
        if (this.zip.exists()) {
            throw new IllegalArgumentException("Cannot create the project because the target zip file already exists");
        }
        this.zip.createNewFile();
        this.zipOutputStream = new ZipArchiveOutputStream(Files.newOutputStream(this.zip.toPath(), new OpenOption[0]));
        this.directory = project.getName();
        this.lastModified = FileTime.from(OutputUtils.createLastModified());
    }

    public ZipOutputHandler(OutputStream outputStream) {
        this(null, outputStream);
    }

    public ZipOutputHandler(String projectName, OutputStream outputStream) {
        this.zip = null;
        this.zipOutputStream = new ZipArchiveOutputStream(outputStream);
        this.directory = projectName;
        this.lastModified = FileTime.from(OutputUtils.createLastModified());
    }

    @Override
    public String getOutputLocation() {
        if (this.zip == null) {
            return null;
        }
        return this.zip.getAbsolutePath();
    }

    @Override
    public boolean exists(String path) {
        return false;
    }

    @Override
    public void write(String path, Template contents) throws IOException {
        String entryName = this.directory != null ? StringUtils.prependUri(this.directory, path) : path;
        this.createParentDirs(entryName, this.lastModified);
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(entryName);
        this.setZipEntryMetadata(zipEntry, this.lastModified, 0x8000 | (contents.isExecutable() ? 493 : 420));
        this.zipOutputStream.putArchiveEntry(zipEntry);
        contents.write(this.zipOutputStream);
        this.zipOutputStream.closeArchiveEntry();
    }

    @Override
    public void close() throws IOException {
        this.zipOutputStream.finish();
        this.zipOutputStream.close();
    }

    private void createParentDirs(String entryName, FileTime lastModified) throws IOException {
        int slash = entryName.lastIndexOf(47);
        if (slash < 0) {
            return;
        }
        int i2 = 0;
        while ((i2 = entryName.indexOf(47, i2)) >= 0) {
            String dir = entryName.substring(0, i2 + 1);
            if (this.createdDirs.add(dir)) {
                ZipArchiveEntry directoryEntry = new ZipArchiveEntry(dir);
                this.setZipEntryMetadata(directoryEntry, lastModified, 16877);
                this.zipOutputStream.putArchiveEntry(directoryEntry);
                this.zipOutputStream.closeArchiveEntry();
            }
            ++i2;
        }
    }

    private void setZipEntryMetadata(ZipArchiveEntry zipEntry, FileTime lastModified, int unixMode) {
        zipEntry.setLastModifiedTime(lastModified);
        zipEntry.setTime(lastModified.toMillis());
        zipEntry.setUnixMode(unixMode);
    }
}

