/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.reader.HistoryReader;
import net.openhft.chronicle.queue.util.ToolsUtil;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.VanillaMethodReader;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public final class InternalChronicleHistoryReader
implements HistoryReader {
    private static final int SUMMARY_OUTPUT_UNSET = -999;
    private final Supplier<? extends ChronicleQueue> queueSupplier;
    private Path basePath;
    private Consumer<String> messageSink;
    private boolean progress = false;
    private TimeUnit timeUnit = TimeUnit.NANOSECONDS;
    private boolean histosByMethod = false;
    private Map<String, Histogram> histos = new LinkedHashMap<String, Histogram>();
    private long ignore = 0L;
    private long counter = 0L;
    private long measurementWindowNanos = 0L;
    private long firstTimeStampNanos = 0L;
    private long lastWindowCount = 0L;
    private int summaryOutputOffset = -999;
    private int lastHistosSize = 0;

    public InternalChronicleHistoryReader() {
        this.queueSupplier = null;
    }

    public InternalChronicleHistoryReader(@NotNull Supplier<? extends ChronicleQueue> queueSupplier) {
        this.queueSupplier = ObjectUtils.requireNonNull(queueSupplier);
    }

    @Override
    public InternalChronicleHistoryReader withMessageSink(Consumer<String> messageSink) {
        this.messageSink = messageSink;
        return this;
    }

    @Override
    public InternalChronicleHistoryReader withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    @Override
    public InternalChronicleHistoryReader withProgress(boolean p) {
        this.progress = p;
        return this;
    }

    @Override
    public InternalChronicleHistoryReader withTimeUnit(TimeUnit p) {
        this.timeUnit = p;
        return this;
    }

    @Override
    public InternalChronicleHistoryReader withHistosByMethod(boolean b) {
        this.histosByMethod = b;
        return this;
    }

    @Override
    public InternalChronicleHistoryReader withIgnore(long ignore) {
        this.ignore = ignore;
        return this;
    }

    @Override
    public InternalChronicleHistoryReader withMeasurementWindow(long measurementWindow) {
        this.measurementWindowNanos = this.timeUnit.toNanos(measurementWindow);
        return this;
    }

    @Override
    public InternalChronicleHistoryReader withSummaryOutput(int offset) {
        this.summaryOutputOffset = offset;
        return this;
    }

    @NotNull
    private ChronicleQueue createQueue() {
        if (this.queueSupplier != null) {
            return this.queueSupplier.get();
        }
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path %s does not exist", this.basePath));
        }
        return SingleChronicleQueueBuilder.binary(this.basePath.toFile()).readOnly(true).build();
    }

    @Override
    public void execute() {
        this.readChronicle();
        if (this.measurementWindowNanos == 0L) {
            this.outputData();
        }
    }

    @Override
    public Map<String, Histogram> readChronicle() {
        try (ChronicleQueue q = this.createQueue();){
            ExcerptTailer tailer = q.createTailer();
            WireParselet parselet = this.parselet();
            MessageHistory.set((MessageHistory)new VanillaMessageHistory());
            try (VanillaMethodReader mr = new VanillaMethodReader((MarshallableIn)tailer, true, parselet, null, new Object[]{parselet});){
                while (!Thread.currentThread().isInterrupted() && mr.readOne()) {
                    ++this.counter;
                    if (!this.progress || this.counter % 1000000L != 0L) continue;
                    System.out.println("Progress: " + this.counter);
                }
            }
        }
        return this.histos;
    }

    @Override
    public void outputData() {
        if (this.summaryOutputOffset != -999) {
            this.printSummary();
        } else {
            this.printPercentilesSummary();
        }
    }

    private void printPercentilesSummary() {
        if (this.histos.size() == 0) {
            this.messageSink.accept("No data");
            return;
        }
        int counter = 0;
        this.messageSink.accept("Timings below in " + this.timeUnit.name());
        StringBuilder sb = new StringBuilder("sourceId        ");
        this.histos.forEach((id, histogram) -> sb.append(String.format("%12s ", id)));
        this.messageSink.accept(sb.toString());
        this.messageSink.accept("count:  " + this.count());
        this.messageSink.accept("50:     " + this.percentiles(counter++));
        this.messageSink.accept("90:     " + this.percentiles(counter++));
        this.messageSink.accept("99:     " + this.percentiles(counter++));
        this.messageSink.accept("99.9:   " + this.percentiles(counter++));
        this.messageSink.accept("99.99:  " + this.percentiles(counter++));
        this.messageSink.accept("99.999: " + this.percentiles(counter++));
        this.messageSink.accept("99.9999:" + this.percentiles(counter++));
        this.messageSink.accept("worst:  " + this.percentiles(-1));
    }

    private void printSummary() {
        if (this.histos.size() > this.lastHistosSize) {
            this.messageSink.accept("relative_ts," + String.join((CharSequence)",", this.histos.keySet()));
            this.lastHistosSize = this.histos.size();
        }
        long tsSinceStart = this.lastWindowCount * this.measurementWindowNanos - this.firstTimeStampNanos;
        this.messageSink.accept(this.timeUnit.convert(tsSinceStart, TimeUnit.NANOSECONDS) + "," + this.histos.values().stream().map(h -> Long.toString(this.timeUnit.convert((long)this.offset(h.getPercentiles(), this.summaryOutputOffset), TimeUnit.NANOSECONDS))).collect(Collectors.joining(",")));
    }

    private double offset(double[] percentiles, int offset) {
        return offset >= 0 ? percentiles[offset] : percentiles[percentiles.length + offset];
    }

    private String count() {
        StringBuilder sb = new StringBuilder("        ");
        this.histos.forEach((id, histogram) -> sb.append(String.format("%12d ", histogram.totalCount())));
        return sb.toString();
    }

    private String percentiles(int index) {
        StringBuilder sb = new StringBuilder("        ");
        this.histos.forEach((id, histogram) -> {
            double[] percentiles = histogram.getPercentiles();
            if (index >= percentiles.length - 1) {
                sb.append(String.format("%12s ", " "));
                return;
            }
            int myIndex = index;
            if (myIndex == -1) {
                myIndex = percentiles.length - 1;
            }
            double value = percentiles[myIndex];
            sb.append(String.format("%12d ", this.timeUnit.convert((long)value, TimeUnit.NANOSECONDS)));
        });
        return sb.toString();
    }

    private WireParselet parselet() {
        return (methodName, v) -> {
            v.skipValue();
            if (this.counter < this.ignore) {
                return;
            }
            MessageHistory history = MessageHistory.get();
            if (history == null) {
                return;
            }
            this.processMessage(methodName, history);
            if (history.timings() > 0) {
                long firstTiming = history.timing(0);
                if (this.measurementWindowNanos > 0L) {
                    long windowCount = firstTiming / this.measurementWindowNanos;
                    if (windowCount > this.lastWindowCount) {
                        this.windowPassed();
                        this.lastWindowCount = windowCount;
                    }
                    if (this.firstTimeStampNanos == 0L) {
                        this.firstTimeStampNanos = firstTiming;
                    }
                }
            }
        };
    }

    private void processMessage(CharSequence methodName, MessageHistory history) {
        String extraHistoId = this.histosByMethod ? "_" + methodName : "";
        long lastTime = 0L;
        int firstWriteOffset = history.timings() - history.sources() * 2;
        if (firstWriteOffset != 0 && firstWriteOffset != 1) {
            return;
        }
        for (int sourceIndex = 0; sourceIndex < history.sources(); ++sourceIndex) {
            Histogram histo1;
            String histoId = Integer.toString(history.sourceId(sourceIndex)) + extraHistoId;
            Histogram histo = this.histos.computeIfAbsent(histoId, s -> this.histogram());
            long receivedByThisComponent = history.timing(2 * sourceIndex + firstWriteOffset);
            long processedByThisComponent = history.timing(2 * sourceIndex + firstWriteOffset + 1);
            histo.sample(processedByThisComponent - receivedByThisComponent);
            if (lastTime == 0L && firstWriteOffset > 0) {
                histo1 = this.histos.computeIfAbsent("startTo" + histoId, s -> this.histogram());
                histo1.sample(receivedByThisComponent - history.timing(0));
            } else if (lastTime != 0L) {
                histo1 = this.histos.computeIfAbsent(history.sourceId(sourceIndex - 1) + "to" + histoId, s -> this.histogram());
                histo1.sample(receivedByThisComponent - lastTime);
            }
            lastTime = processedByThisComponent;
        }
        if (history.sources() > 1) {
            Histogram histoE2E = this.histos.computeIfAbsent("endToEnd", s -> this.histogram());
            histoE2E.sample(history.timing(history.timings() - 1) - history.timing(0));
        }
    }

    protected void windowPassed() {
        this.outputData();
        this.histos.values().forEach(Histogram::reset);
    }

    @NotNull
    protected Histogram histogram() {
        return new Histogram(60, 4);
    }

    static {
        ToolsUtil.warnIfResourceTracing();
    }
}

