/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.schema.Drop;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultDropKeyspace
implements Drop {
    private final CqlIdentifier keyspaceName;
    private final boolean ifExists;

    public DefaultDropKeyspace(@NonNull CqlIdentifier keyspaceName) {
        this(keyspaceName, false);
    }

    public DefaultDropKeyspace(@NonNull CqlIdentifier keyspaceName, boolean ifExists) {
        this.keyspaceName = keyspaceName;
        this.ifExists = ifExists;
    }

    @Override
    @NonNull
    public Drop ifExists() {
        return new DefaultDropKeyspace(this.keyspaceName, true);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("DROP KEYSPACE ");
        if (this.ifExists) {
            builder.append("IF EXISTS ");
        }
        builder.append(this.keyspaceName.asCql(true));
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspaceName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }
}

