/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.logging.DefaultLogLevel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.util.Utils;

public class LoggingObject
implements ILoggingObject {
    private String logChannelId;
    private LoggingObjectType objectType;
    private String objectName;
    private String objectCopy;
    private String filename;
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    private String containerObjectId;
    private ILoggingObject parent;
    private Date registrationDate;
    private boolean gatheringMetrics;
    private boolean forcingSeparateLogging;

    public LoggingObject(Object object) {
        if (object instanceof ILoggingObject) {
            ILoggingObject iLoggingObject = (ILoggingObject)object;
            this.grabLoggingObjectInformation(iLoggingObject);
        } else {
            this.grabObjectInformation(object);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoggingObject)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            boolean sameParents;
            LoggingObject loggingObject = (LoggingObject)obj;
            if (StringUtils.isNotEmpty((String)this.getFilename()) && StringUtils.isEmpty((String)loggingObject.getFilename()) || StringUtils.isEmpty((String)this.getFilename()) && StringUtils.isNotEmpty((String)loggingObject.getFilename()) || StringUtils.isNotEmpty((String)this.getFilename()) && StringUtils.isNotEmpty((String)loggingObject.getFilename()) && !this.getFilename().equals(loggingObject.getFilename())) {
                return false;
            }
            boolean sameCarteFamily = this.getContainerId() == null && loggingObject.getContainerId() == null || this.getContainerId() != null && loggingObject.getContainerId() != null && this.getContainerId().equals(loggingObject.getContainerId());
            boolean bl = sameParents = loggingObject.getParent() == null && this.getParent() == null || loggingObject.getParent() != null && this.getParent() != null && loggingObject.getParent().equals(this.getParent());
            if (sameCarteFamily && !Utils.isEmpty(loggingObject.getFilename()) && loggingObject.getFilename().equals(this.getFilename()) && sameParents && StringUtils.equals((String)loggingObject.getObjectName(), (String)this.getObjectName())) {
                return true;
            }
            if (!sameCarteFamily || loggingObject.getObjectName() == null && this.getObjectName() != null || loggingObject.getObjectName() != null && this.getObjectName() == null) {
                return false;
            }
            if (sameCarteFamily && (loggingObject.getObjectName() == null && this.getObjectName() == null || loggingObject.getObjectName().equals(this.getObjectName())) && loggingObject.getObjectType().equals((Object)this.getObjectType())) {
                if (!Utils.isEmpty(this.getObjectCopy()) && !this.getObjectCopy().equals(loggingObject.getObjectCopy())) {
                    return false;
                }
                ILoggingObject parent1 = loggingObject.getParent();
                ILoggingObject parent2 = this.getParent();
                if (parent1 != null && parent2 == null || parent1 == null && parent2 != null) {
                    return false;
                }
                if (parent1 == null && parent2 == null) {
                    return true;
                }
                if (parent1.equals(parent2)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void grabLoggingObjectInformation(ILoggingObject loggingObject) {
        this.objectType = loggingObject.getObjectType();
        this.objectName = loggingObject.getObjectName();
        this.filename = loggingObject.getFilename();
        this.objectCopy = loggingObject.getObjectCopy();
        this.logLevel = loggingObject.getLogLevel();
        this.containerObjectId = loggingObject.getContainerId();
        this.forcingSeparateLogging = loggingObject.isForcingSeparateLogging();
        this.gatheringMetrics = loggingObject.isGatheringMetrics();
        if (loggingObject.getParent() != null) {
            this.getParentLoggingObject(loggingObject.getParent());
            this.containerObjectId = loggingObject.getParent().getContainerId();
        }
    }

    private void grabObjectInformation(Object object) {
        this.objectType = LoggingObjectType.GENERAL;
        this.objectName = object.toString();
        this.parent = null;
    }

    private void getParentLoggingObject(Object parentObject) {
        LoggingObject check;
        if (parentObject == null) {
            return;
        }
        if (parentObject instanceof ILoggingObject) {
            ILoggingObject parentLoggingObject;
            ILoggingObject iLoggingObject;
            this.parent = iLoggingObject = (ILoggingObject)parentObject;
            if (this.parent.getLogChannelId() != null && (parentLoggingObject = LoggingRegistry.getInstance().getLoggingObject(this.parent.getLogChannelId())) != null) {
                this.parent = parentLoggingObject;
            }
            return;
        }
        LoggingRegistry registry = LoggingRegistry.getInstance();
        ILoggingObject loggingObject = registry.findExistingLoggingSource(check = new LoggingObject(parentObject));
        if (loggingObject == null) {
            String logChannelId = registry.registerLoggingSource(check);
            loggingObject = check;
            check.setLogChannelId(logChannelId);
        }
        this.parent = loggingObject;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String name) {
        this.objectName = name;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    @Override
    public ILoggingObject getParent() {
        return this.parent;
    }

    public void setParent(ILoggingObject parent) {
        this.parent = parent;
    }

    @Override
    public LoggingObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(LoggingObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public String getObjectCopy() {
        return this.objectCopy;
    }

    public void setObjectCopy(String objectCopy) {
        this.objectCopy = objectCopy;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getContainerId() {
        return this.containerObjectId;
    }

    public void setCarteObjectId(String serverObjectId) {
        this.containerObjectId = serverObjectId;
    }

    @Override
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    @Override
    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }

    @Override
    public boolean isForcingSeparateLogging() {
        return this.forcingSeparateLogging;
    }

    @Override
    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        this.forcingSeparateLogging = forcingSeparateLogging;
    }
}

