/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.service.StartupChecks;

public class StartupChecksOptions {
    public static final String ENABLED_PROPERTY = "enabled";
    private final Map<StartupChecks.StartupCheckType, Map<String, Object>> options = new EnumMap<StartupChecks.StartupCheckType, Map<String, Object>>(StartupChecks.StartupCheckType.class);

    public StartupChecksOptions() {
        this(Collections.emptyMap());
    }

    public StartupChecksOptions(Map<StartupChecks.StartupCheckType, Map<String, Object>> options) {
        this.options.putAll(options);
        this.apply();
    }

    public void set(StartupChecks.StartupCheckType startupCheckType, String key, Object value) {
        if (startupCheckType != StartupChecks.StartupCheckType.non_configurable_check) {
            this.options.get((Object)startupCheckType).put(key, value);
        }
    }

    public void enable(StartupChecks.StartupCheckType startupCheckType) {
        this.set(startupCheckType, ENABLED_PROPERTY, Boolean.TRUE);
    }

    public void disable(StartupChecks.StartupCheckType startupCheckType) {
        if (startupCheckType != StartupChecks.StartupCheckType.non_configurable_check) {
            this.set(startupCheckType, ENABLED_PROPERTY, Boolean.FALSE);
        }
    }

    public boolean isEnabled(StartupChecks.StartupCheckType startupCheckType) {
        return Boolean.parseBoolean(this.options.get((Object)startupCheckType).get(ENABLED_PROPERTY).toString());
    }

    public boolean isDisabled(StartupChecks.StartupCheckType startupCheckType) {
        return !this.isEnabled(startupCheckType);
    }

    public Map<String, Object> getConfig(StartupChecks.StartupCheckType startupCheckType) {
        return this.options.get((Object)startupCheckType);
    }

    private void apply() {
        for (StartupChecks.StartupCheckType startupCheckType : StartupChecks.StartupCheckType.values()) {
            Map configMap = this.options.computeIfAbsent(startupCheckType, k -> new HashMap());
            if (configMap.containsKey(ENABLED_PROPERTY)) {
                configMap.putIfAbsent(ENABLED_PROPERTY, Boolean.FALSE);
                continue;
            }
            if (startupCheckType.disabledByDefault) {
                configMap.put(ENABLED_PROPERTY, Boolean.FALSE);
                continue;
            }
            configMap.put(ENABLED_PROPERTY, Boolean.TRUE);
        }
        this.options.get((Object)StartupChecks.StartupCheckType.non_configurable_check).clear();
        this.options.get((Object)StartupChecks.StartupCheckType.non_configurable_check).put(ENABLED_PROPERTY, Boolean.TRUE);
    }
}

