/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.fileproperties.PropertyGroup;
import com.dropbox.core.v2.files.ExportInfo;
import com.dropbox.core.v2.files.FileLockMetadata;
import com.dropbox.core.v2.files.FileSharingInfo;
import com.dropbox.core.v2.files.MediaInfo;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.SymlinkInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileMetadata
extends Metadata {
    @Nonnull
    protected final String id;
    @Nonnull
    protected final Date clientModified;
    @Nonnull
    protected final Date serverModified;
    @Nonnull
    protected final String rev;
    protected final long size;
    @Nullable
    protected final MediaInfo mediaInfo;
    @Nullable
    protected final SymlinkInfo symlinkInfo;
    @Nullable
    protected final FileSharingInfo sharingInfo;
    protected final boolean isDownloadable;
    @Nullable
    protected final ExportInfo exportInfo;
    @Nullable
    protected final List<PropertyGroup> propertyGroups;
    @Nullable
    protected final Boolean hasExplicitSharedMembers;
    @Nullable
    protected final String contentHash;
    @Nullable
    protected final FileLockMetadata fileLockInfo;

    public FileMetadata(@Nonnull String name, @Nonnull String id, @Nonnull Date clientModified, @Nonnull Date serverModified, @Nonnull String rev, long size, @Nullable String pathLower, @Nullable String pathDisplay, @Nullable String parentSharedFolderId, @Nullable String previewUrl, @Nullable MediaInfo mediaInfo, @Nullable SymlinkInfo symlinkInfo, @Nullable FileSharingInfo sharingInfo, boolean isDownloadable, @Nullable ExportInfo exportInfo, @Nullable List<PropertyGroup> propertyGroups, @Nullable Boolean hasExplicitSharedMembers, @Nullable String contentHash, @Nullable FileLockMetadata fileLockInfo) {
        super(name, pathLower, pathDisplay, parentSharedFolderId, previewUrl);
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        this.id = id;
        if (clientModified == null) {
            throw new IllegalArgumentException("Required value for 'clientModified' is null");
        }
        this.clientModified = LangUtil.truncateMillis(clientModified);
        if (serverModified == null) {
            throw new IllegalArgumentException("Required value for 'serverModified' is null");
        }
        this.serverModified = LangUtil.truncateMillis(serverModified);
        if (rev == null) {
            throw new IllegalArgumentException("Required value for 'rev' is null");
        }
        if (rev.length() < 9) {
            throw new IllegalArgumentException("String 'rev' is shorter than 9");
        }
        if (!Pattern.matches("[0-9a-f]+", rev)) {
            throw new IllegalArgumentException("String 'rev' does not match pattern");
        }
        this.rev = rev;
        this.size = size;
        this.mediaInfo = mediaInfo;
        this.symlinkInfo = symlinkInfo;
        this.sharingInfo = sharingInfo;
        this.isDownloadable = isDownloadable;
        this.exportInfo = exportInfo;
        if (propertyGroups != null) {
            for (PropertyGroup x : propertyGroups) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
            }
        }
        this.propertyGroups = propertyGroups;
        this.hasExplicitSharedMembers = hasExplicitSharedMembers;
        if (contentHash != null) {
            if (contentHash.length() < 64) {
                throw new IllegalArgumentException("String 'contentHash' is shorter than 64");
            }
            if (contentHash.length() > 64) {
                throw new IllegalArgumentException("String 'contentHash' is longer than 64");
            }
        }
        this.contentHash = contentHash;
        this.fileLockInfo = fileLockInfo;
    }

    public FileMetadata(@Nonnull String name, @Nonnull String id, @Nonnull Date clientModified, @Nonnull Date serverModified, @Nonnull String rev, long size) {
        this(name, id, clientModified, serverModified, rev, size, null, null, null, null, null, null, null, true, null, null, null, null, null);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public Date getClientModified() {
        return this.clientModified;
    }

    @Nonnull
    public Date getServerModified() {
        return this.serverModified;
    }

    @Nonnull
    public String getRev() {
        return this.rev;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    @Nullable
    public String getPathLower() {
        return this.pathLower;
    }

    @Override
    @Nullable
    public String getPathDisplay() {
        return this.pathDisplay;
    }

    @Override
    @Nullable
    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    @Override
    @Nullable
    public String getPreviewUrl() {
        return this.previewUrl;
    }

    @Nullable
    public MediaInfo getMediaInfo() {
        return this.mediaInfo;
    }

    @Nullable
    public SymlinkInfo getSymlinkInfo() {
        return this.symlinkInfo;
    }

    @Nullable
    public FileSharingInfo getSharingInfo() {
        return this.sharingInfo;
    }

    public boolean getIsDownloadable() {
        return this.isDownloadable;
    }

    @Nullable
    public ExportInfo getExportInfo() {
        return this.exportInfo;
    }

    @Nullable
    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    @Nullable
    public Boolean getHasExplicitSharedMembers() {
        return this.hasExplicitSharedMembers;
    }

    @Nullable
    public String getContentHash() {
        return this.contentHash;
    }

    @Nullable
    public FileLockMetadata getFileLockInfo() {
        return this.fileLockInfo;
    }

    public static Builder newBuilder(String name, String id, Date clientModified, Date serverModified, String rev, long size) {
        return new Builder(name, id, clientModified, serverModified, rev, size);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.clientModified, this.serverModified, this.rev, this.size, this.mediaInfo, this.symlinkInfo, this.sharingInfo, this.isDownloadable, this.exportInfo, this.propertyGroups, this.hasExplicitSharedMembers, this.contentHash, this.fileLockInfo});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileMetadata other = (FileMetadata)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.id != other.id && !this.id.equals(other.id) || this.clientModified != other.clientModified && !this.clientModified.equals(other.clientModified) || this.serverModified != other.serverModified && !this.serverModified.equals(other.serverModified) || this.rev != other.rev && !this.rev.equals(other.rev) || this.size != other.size || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.pathDisplay != other.pathDisplay && (this.pathDisplay == null || !this.pathDisplay.equals(other.pathDisplay)) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)) || this.previewUrl != other.previewUrl && (this.previewUrl == null || !this.previewUrl.equals(other.previewUrl)) || this.mediaInfo != other.mediaInfo && (this.mediaInfo == null || !this.mediaInfo.equals(other.mediaInfo)) || this.symlinkInfo != other.symlinkInfo && (this.symlinkInfo == null || !this.symlinkInfo.equals(other.symlinkInfo)) || this.sharingInfo != other.sharingInfo && (this.sharingInfo == null || !this.sharingInfo.equals(other.sharingInfo)) || this.isDownloadable != other.isDownloadable || this.exportInfo != other.exportInfo && (this.exportInfo == null || !this.exportInfo.equals(other.exportInfo)) || this.propertyGroups != other.propertyGroups && (this.propertyGroups == null || !this.propertyGroups.equals(other.propertyGroups)) || this.hasExplicitSharedMembers != other.hasExplicitSharedMembers && (this.hasExplicitSharedMembers == null || !this.hasExplicitSharedMembers.equals(other.hasExplicitSharedMembers)) || this.contentHash != other.contentHash && (this.contentHash == null || !this.contentHash.equals(other.contentHash)) || this.fileLockInfo != other.fileLockInfo && (this.fileLockInfo == null || !this.fileLockInfo.equals(other.fileLockInfo)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            this.writeTag("file", g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("client_modified");
            StoneSerializers.timestamp().serialize(value.clientModified, g);
            g.writeFieldName("server_modified");
            StoneSerializers.timestamp().serialize(value.serverModified, g);
            g.writeFieldName("rev");
            StoneSerializers.string().serialize(value.rev, g);
            g.writeFieldName("size");
            StoneSerializers.uInt64().serialize((Long)value.size, g);
            if (value.pathLower != null) {
                g.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g);
            }
            if (value.pathDisplay != null) {
                g.writeFieldName("path_display");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathDisplay, g);
            }
            if (value.parentSharedFolderId != null) {
                g.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g);
            }
            if (value.previewUrl != null) {
                g.writeFieldName("preview_url");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.previewUrl, g);
            }
            if (value.mediaInfo != null) {
                g.writeFieldName("media_info");
                StoneSerializers.nullable(MediaInfo.Serializer.INSTANCE).serialize(value.mediaInfo, g);
            }
            if (value.symlinkInfo != null) {
                g.writeFieldName("symlink_info");
                StoneSerializers.nullableStruct(SymlinkInfo.Serializer.INSTANCE).serialize(value.symlinkInfo, g);
            }
            if (value.sharingInfo != null) {
                g.writeFieldName("sharing_info");
                StoneSerializers.nullableStruct(FileSharingInfo.Serializer.INSTANCE).serialize(value.sharingInfo, g);
            }
            g.writeFieldName("is_downloadable");
            StoneSerializers.boolean_().serialize((Boolean)value.isDownloadable, g);
            if (value.exportInfo != null) {
                g.writeFieldName("export_info");
                StoneSerializers.nullableStruct(ExportInfo.Serializer.INSTANCE).serialize(value.exportInfo, g);
            }
            if (value.propertyGroups != null) {
                g.writeFieldName("property_groups");
                StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).serialize(value.propertyGroups, g);
            }
            if (value.hasExplicitSharedMembers != null) {
                g.writeFieldName("has_explicit_shared_members");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.hasExplicitSharedMembers, g);
            }
            if (value.contentHash != null) {
                g.writeFieldName("content_hash");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.contentHash, g);
            }
            if (value.fileLockInfo != null) {
                g.writeFieldName("file_lock_info");
                StoneSerializers.nullableStruct(FileLockMetadata.Serializer.INSTANCE).serialize(value.fileLockInfo, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            FileLockMetadata f_fileLockInfo;
            String f_contentHash;
            Boolean f_hasExplicitSharedMembers;
            List<PropertyGroup> f_propertyGroups;
            ExportInfo f_exportInfo;
            Boolean f_isDownloadable;
            FileSharingInfo f_sharingInfo;
            SymlinkInfo f_symlinkInfo;
            MediaInfo f_mediaInfo;
            String f_previewUrl;
            String f_parentSharedFolderId;
            String f_pathDisplay;
            String f_pathLower;
            Long f_size;
            String f_rev;
            Date f_serverModified;
            Date f_clientModified;
            String f_id;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("file".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_name = null;
                f_id = null;
                f_clientModified = null;
                f_serverModified = null;
                f_rev = null;
                f_size = null;
                f_pathLower = null;
                f_pathDisplay = null;
                f_parentSharedFolderId = null;
                f_previewUrl = null;
                f_mediaInfo = null;
                f_symlinkInfo = null;
                f_sharingInfo = null;
                f_isDownloadable = true;
                f_exportInfo = null;
                f_propertyGroups = null;
                f_hasExplicitSharedMembers = null;
                f_contentHash = null;
                f_fileLockInfo = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("client_modified".equals(field)) {
                        f_clientModified = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("server_modified".equals(field)) {
                        f_serverModified = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("rev".equals(field)) {
                        f_rev = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("size".equals(field)) {
                        f_size = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_display".equals(field)) {
                        f_pathDisplay = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("preview_url".equals(field)) {
                        f_previewUrl = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("media_info".equals(field)) {
                        f_mediaInfo = StoneSerializers.nullable(MediaInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("symlink_info".equals(field)) {
                        f_symlinkInfo = StoneSerializers.nullableStruct(SymlinkInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("sharing_info".equals(field)) {
                        f_sharingInfo = StoneSerializers.nullableStruct(FileSharingInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("is_downloadable".equals(field)) {
                        f_isDownloadable = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("export_info".equals(field)) {
                        f_exportInfo = StoneSerializers.nullableStruct(ExportInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("property_groups".equals(field)) {
                        f_propertyGroups = StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("has_explicit_shared_members".equals(field)) {
                        f_hasExplicitSharedMembers = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("content_hash".equals(field)) {
                        f_contentHash = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_lock_info".equals(field)) {
                        f_fileLockInfo = StoneSerializers.nullableStruct(FileLockMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
                if (f_clientModified == null) {
                    throw new JsonParseException(p, "Required field \"client_modified\" missing.");
                }
                if (f_serverModified == null) {
                    throw new JsonParseException(p, "Required field \"server_modified\" missing.");
                }
                if (f_rev == null) {
                    throw new JsonParseException(p, "Required field \"rev\" missing.");
                }
                if (f_size == null) {
                    throw new JsonParseException(p, "Required field \"size\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileMetadata value = new FileMetadata(f_name, f_id, f_clientModified, f_serverModified, f_rev, f_size, f_pathLower, f_pathDisplay, f_parentSharedFolderId, f_previewUrl, f_mediaInfo, f_symlinkInfo, f_sharingInfo, f_isDownloadable, f_exportInfo, f_propertyGroups, f_hasExplicitSharedMembers, f_contentHash, f_fileLockInfo);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends Metadata.Builder {
        protected final String id;
        protected final Date clientModified;
        protected final Date serverModified;
        protected final String rev;
        protected final long size;
        protected MediaInfo mediaInfo;
        protected SymlinkInfo symlinkInfo;
        protected FileSharingInfo sharingInfo;
        protected boolean isDownloadable;
        protected ExportInfo exportInfo;
        protected List<PropertyGroup> propertyGroups;
        protected Boolean hasExplicitSharedMembers;
        protected String contentHash;
        protected FileLockMetadata fileLockInfo;

        protected Builder(String name, String id, Date clientModified, Date serverModified, String rev, long size) {
            super(name);
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            this.id = id;
            if (clientModified == null) {
                throw new IllegalArgumentException("Required value for 'clientModified' is null");
            }
            this.clientModified = LangUtil.truncateMillis(clientModified);
            if (serverModified == null) {
                throw new IllegalArgumentException("Required value for 'serverModified' is null");
            }
            this.serverModified = LangUtil.truncateMillis(serverModified);
            if (rev == null) {
                throw new IllegalArgumentException("Required value for 'rev' is null");
            }
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
            this.rev = rev;
            this.size = size;
            this.mediaInfo = null;
            this.symlinkInfo = null;
            this.sharingInfo = null;
            this.isDownloadable = true;
            this.exportInfo = null;
            this.propertyGroups = null;
            this.hasExplicitSharedMembers = null;
            this.contentHash = null;
            this.fileLockInfo = null;
        }

        public Builder withMediaInfo(MediaInfo mediaInfo) {
            this.mediaInfo = mediaInfo;
            return this;
        }

        public Builder withSymlinkInfo(SymlinkInfo symlinkInfo) {
            this.symlinkInfo = symlinkInfo;
            return this;
        }

        public Builder withSharingInfo(FileSharingInfo sharingInfo) {
            this.sharingInfo = sharingInfo;
            return this;
        }

        public Builder withIsDownloadable(Boolean isDownloadable) {
            this.isDownloadable = isDownloadable != null ? isDownloadable : true;
            return this;
        }

        public Builder withExportInfo(ExportInfo exportInfo) {
            this.exportInfo = exportInfo;
            return this;
        }

        public Builder withPropertyGroups(List<PropertyGroup> propertyGroups) {
            if (propertyGroups != null) {
                for (PropertyGroup x : propertyGroups) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
                }
            }
            this.propertyGroups = propertyGroups;
            return this;
        }

        public Builder withHasExplicitSharedMembers(Boolean hasExplicitSharedMembers) {
            this.hasExplicitSharedMembers = hasExplicitSharedMembers;
            return this;
        }

        public Builder withContentHash(String contentHash) {
            if (contentHash != null) {
                if (contentHash.length() < 64) {
                    throw new IllegalArgumentException("String 'contentHash' is shorter than 64");
                }
                if (contentHash.length() > 64) {
                    throw new IllegalArgumentException("String 'contentHash' is longer than 64");
                }
            }
            this.contentHash = contentHash;
            return this;
        }

        public Builder withFileLockInfo(FileLockMetadata fileLockInfo) {
            this.fileLockInfo = fileLockInfo;
            return this;
        }

        @Override
        public Builder withPathLower(String pathLower) {
            super.withPathLower(pathLower);
            return this;
        }

        @Override
        public Builder withPathDisplay(String pathDisplay) {
            super.withPathDisplay(pathDisplay);
            return this;
        }

        @Override
        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            super.withParentSharedFolderId(parentSharedFolderId);
            return this;
        }

        @Override
        public Builder withPreviewUrl(String previewUrl) {
            super.withPreviewUrl(previewUrl);
            return this;
        }

        @Override
        public FileMetadata build() {
            return new FileMetadata(this.name, this.id, this.clientModified, this.serverModified, this.rev, this.size, this.pathLower, this.pathDisplay, this.parentSharedFolderId, this.previewUrl, this.mediaInfo, this.symlinkInfo, this.sharingInfo, this.isDownloadable, this.exportInfo, this.propertyGroups, this.hasExplicitSharedMembers, this.contentHash, this.fileLockInfo);
        }
    }
}

