/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tika;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.tika.TikaFile;
import org.apache.hop.pipeline.transforms.tika.TikaMeta;
import org.apache.hop.pipeline.transforms.tika.TikaOutput;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TikaDialog
extends BaseTransformDialog {
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};
    private static final Class<?> PKG = TikaMeta.class;
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private final TikaMeta input;
    private CTabFolder wTabFolder;
    private Label wlFilename;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private Label wlFilemask;
    private TextVar wFilemask;
    private Label wlExcludeFilemask;
    private TextVar wExcludeFilemask;
    private Button wbShowFiles;
    private CCombo wFilenameField;
    private Button wFilenameInField;
    private Label wlAddResult;
    private Button wAddResult;
    private Button wIgnoreEmptyFile;
    private TextVar wInclFilenameField;
    private TextVar wRowNumField;
    private Text wLimit;
    private Label wlEncoding;
    private CCombo wEncoding;
    private CCombo wOutputFormat;
    private boolean gotEncodings = false;
    private boolean gotPreviousFields = false;
    private TextVar wContentFieldName;
    private TextVar wFileSizeFieldName;
    private TextVar wShortFileFieldName;
    private TextVar wPathFieldName;
    private TextVar wIsHiddenName;
    private TextVar wLastModificationTimeName;
    private TextVar wUriName;
    private TextVar wRootUriName;
    private TextVar wExtensionFieldName;
    private TextVar wMetadataFieldName;
    private int middle;
    private int margin;

    public TikaDialog(Shell parent, IVariables variables, TikaMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        TikaOutput tikaOutput;
        Shell parent = this.getParent();
        ClassLoader loader = ((Object)((Object)this.input)).getClass().getClassLoader();
        try {
            tikaOutput = new TikaOutput(loader, LogChannel.UI, this.variables);
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Tika error", "Tika error", e2);
            return null;
        }
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TikaDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"TikaDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        CTabItem wFileTab = new CTabItem(this.wTabFolder, 0);
        wFileTab.setFont(GuiResource.getInstance().getFontDefault());
        wFileTab.setText(BaseMessages.getString(PKG, (String)"TikaDialog.File.Tab", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        Group wOutputField = new Group(wFileComp, 32);
        PropsUi.setLook((Widget)wOutputField);
        wOutputField.setText(BaseMessages.getString(PKG, (String)"TikaDialog.wOutputField.Label", (String[])new String[0]));
        FormLayout outputfieldgroupLayout = new FormLayout();
        outputfieldgroupLayout.marginWidth = 10;
        outputfieldgroupLayout.marginHeight = 10;
        wOutputField.setLayout((Layout)outputfieldgroupLayout);
        Label wlFilenameInField = new Label((Composite)wOutputField, 131072);
        wlFilenameInField.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameInField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameInField);
        FormData fdlFilenameInField = new FormData();
        fdlFilenameInField.left = new FormAttachment(0, -this.margin);
        fdlFilenameInField.top = new FormAttachment(0, this.margin);
        fdlFilenameInField.right = new FormAttachment(this.middle, -2 * this.margin);
        wlFilenameInField.setLayoutData((Object)fdlFilenameInField);
        this.wFilenameInField = new Button((Composite)wOutputField, 32);
        PropsUi.setLook((Widget)this.wFilenameInField);
        this.wFilenameInField.setToolTipText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameInField.Tooltip", (String[])new String[0]));
        FormData fdFileNameInField = new FormData();
        fdFileNameInField.left = new FormAttachment(this.middle, -this.margin);
        fdFileNameInField.top = new FormAttachment((Control)wlFilenameInField, 0, 0x1000000);
        this.wFilenameInField.setLayoutData((Object)fdFileNameInField);
        this.wFilenameInField.addListener(13, e -> {
            this.enableFields();
            this.input.setChanged();
        });
        Label wlFilenameField = new Label((Composite)wOutputField, 131072);
        wlFilenameField.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, this.margin);
        fdlFilenameField.top = new FormAttachment((Control)wlFilenameInField, 2 * this.margin);
        fdlFilenameField.right = new FormAttachment(this.middle, -2 * this.margin);
        wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new CCombo((Composite)wOutputField, 2056);
        this.wFilenameField.setEditable(true);
        PropsUi.setLook((Widget)this.wFilenameField);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(this.middle, -this.margin);
        fdFilenameField.top = new FormAttachment((Control)wlFilenameField, 0, 0x1000000);
        fdFilenameField.right = new FormAttachment(100, -this.margin);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        this.wFilenameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                TikaDialog.this.setDynamicFilenameField();
            }
        });
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(0, this.margin);
        fdOutputField.top = new FormAttachment((Control)this.wFilenameList, this.margin);
        fdOutputField.right = new FormAttachment(100, -this.margin);
        wOutputField.setLayoutData((Object)fdOutputField);
        this.middle /= 2;
        this.wlFilename = new Label(wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"TikaDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)wOutputField, this.margin);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbbFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameBrowse.Button", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)wOutputField, this.margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbaFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameAdd.Button", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        FormData fdbaFilename = new FormData();
        fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -this.margin);
        fdbaFilename.top = new FormAttachment((Control)wOutputField, this.margin);
        this.wbaFilename.setLayoutData((Object)fdbaFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(this.middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbaFilename, -this.margin);
        fdFilename.top = new FormAttachment((Control)wOutputField, this.margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlFilemask = new Label(wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"TikaDialog.RegExp.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilemask);
        FormData fdlFilemask = new FormData();
        fdlFilemask.left = new FormAttachment(0, 0);
        fdlFilemask.top = new FormAttachment((Control)this.wFilename, 2 * this.margin);
        fdlFilemask.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilemask.setLayoutData((Object)fdlFilemask);
        this.wFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilemask);
        FormData fdFilemask = new FormData();
        fdFilemask.left = new FormAttachment(this.middle, 0);
        fdFilemask.top = new FormAttachment((Control)this.wFilename, 2 * this.margin);
        fdFilemask.right = new FormAttachment(100, 0);
        this.wFilemask.setLayoutData((Object)fdFilemask);
        this.wlExcludeFilemask = new Label(wFileComp, 131072);
        this.wlExcludeFilemask.setText(BaseMessages.getString(PKG, (String)"TikaDialog.ExcludeFilemask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlExcludeFilemask);
        FormData fdlExcludeFilemask = new FormData();
        fdlExcludeFilemask.left = new FormAttachment(0, 0);
        fdlExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, this.margin);
        fdlExcludeFilemask.right = new FormAttachment(this.middle, -this.margin);
        this.wlExcludeFilemask.setLayoutData((Object)fdlExcludeFilemask);
        this.wExcludeFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wExcludeFilemask);
        FormData fdExcludeFilemask = new FormData();
        fdExcludeFilemask.left = new FormAttachment(this.middle, 0);
        fdExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, this.margin);
        fdExcludeFilemask.right = new FormAttachment((Control)this.wFilename, 0, 131072);
        this.wExcludeFilemask.setLayoutData((Object)fdExcludeFilemask);
        this.wlFilenameList = new Label(wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameList);
        FormData fdlFilenameList = new FormData();
        fdlFilenameList.left = new FormAttachment(0, 0);
        fdlFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        fdlFilenameList.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilenameList.setLayoutData((Object)fdlFilenameList);
        this.wbdFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameRemove.Label", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameRemove.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.top = new FormAttachment((Control)this.wExcludeFilemask, 40);
        this.wbdFilename.setLayoutData((Object)fdbdFilename);
        this.wbeFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameEdit.Label", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"TikaDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFilename = new FormData();
        fdbeFilename.right = new FormAttachment(100, 0);
        fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, this.margin);
        this.wbeFilename.setLayoutData((Object)fdbeFilename);
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"TikaDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(this.middle, 0);
        fdbShowFiles.bottom = new FormAttachment(100, 0);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        ColumnInfo[] colinfo = new ColumnInfo[5];
        colinfo[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TikaDialog.Files.Filename.Column", (String[])new String[0]), 1, false);
        colinfo[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TikaDialog.Files.Wildcard.Column", (String[])new String[0]), 1, false);
        colinfo[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TikaDialog.Files.ExcludeWildcard.Column", (String[])new String[0]), 1, false);
        colinfo[0].setUsingVariables(true);
        colinfo[1].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"TikaDialog.Files.Wildcard.Tooltip", (String[])new String[0]));
        colinfo[2].setUsingVariables(true);
        colinfo[2].setToolTip(BaseMessages.getString(PKG, (String)"TikaDialog.Files.ExcludeWildcard.Tooltip", (String[])new String[0]));
        colinfo[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TikaDialog.Required.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"TikaDialog.Required.Tooltip", (String[])new String[0]));
        colinfo[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TikaDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[4].setToolTip(BaseMessages.getString(PKG, (String)"TikaDialog.IncludeSubDirs.Tooltip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, wFileComp, 67586, colinfo, 2, null, this.props);
        PropsUi.setLook((Widget)this.wFilenameList);
        FormData fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(this.middle, 0);
        fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -this.margin);
        fdFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        fdFilenameList.bottom = new FormAttachment((Control)this.wbShowFiles, -this.margin);
        this.wFilenameList.setLayoutData((Object)fdFilenameList);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        wFileTab.setControl((Control)wFileComp);
        this.middle = this.props.getMiddlePct();
        CTabItem wContentTab = new CTabItem(this.wTabFolder, 0);
        wContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wContentTab.setText(BaseMessages.getString(PKG, (String)"TikaDialog.Content.Tab", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Group wFileConf = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wFileConf);
        wFileConf.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FileConf.Label", (String[])new String[0]));
        FormLayout xmlConfgroupLayout = new FormLayout();
        xmlConfgroupLayout.marginWidth = 10;
        xmlConfgroupLayout.marginHeight = 10;
        wFileConf.setLayout((Layout)xmlConfgroupLayout);
        this.wlEncoding = new Label((Composite)wFileConf, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"TikaDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment(0, this.margin);
        fdlEncoding.right = new FormAttachment(this.middle, -this.margin);
        this.wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new CCombo((Composite)wFileConf, 2056);
        this.wEncoding.setEditable(true);
        PropsUi.setLook((Widget)this.wEncoding);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(this.middle, 0);
        fdEncoding.top = new FormAttachment(0, this.margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                TikaDialog.this.setEncodings();
            }
        });
        Label wlIgnoreEmptyFile = new Label((Composite)wFileConf, 131072);
        wlIgnoreEmptyFile.setText(BaseMessages.getString(PKG, (String)"TikaDialog.IgnoreEmptyFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnoreEmptyFile);
        FormData fdlIgnoreEmptyFile = new FormData();
        fdlIgnoreEmptyFile.left = new FormAttachment(0, 0);
        fdlIgnoreEmptyFile.top = new FormAttachment((Control)this.wEncoding, this.margin);
        fdlIgnoreEmptyFile.right = new FormAttachment(this.middle, -this.margin);
        wlIgnoreEmptyFile.setLayoutData((Object)fdlIgnoreEmptyFile);
        this.wIgnoreEmptyFile = new Button((Composite)wFileConf, 32);
        PropsUi.setLook((Widget)this.wIgnoreEmptyFile);
        this.wIgnoreEmptyFile.setToolTipText(BaseMessages.getString(PKG, (String)"TikaDialog.IgnoreEmptyFile.Tooltip", (String[])new String[0]));
        FormData fdIgnoreEmptyFile = new FormData();
        fdIgnoreEmptyFile.left = new FormAttachment(this.middle, 0);
        fdIgnoreEmptyFile.top = new FormAttachment((Control)wlIgnoreEmptyFile, 0, 0x1000000);
        this.wIgnoreEmptyFile.setLayoutData((Object)fdIgnoreEmptyFile);
        Label wlLimit = new Label((Composite)wFileConf, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"TikaDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)wlIgnoreEmptyFile, 2 * this.margin);
        fdlLimit.right = new FormAttachment(this.middle, -this.margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text((Composite)wFileConf, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(this.middle, 0);
        fdLimit.top = new FormAttachment((Control)wlLimit, 0, 0x1000000);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlOutputFormat = new Label((Composite)wFileConf, 131072);
        wlOutputFormat.setText(BaseMessages.getString(PKG, (String)"TikaDialog.OutputFormat.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOutputFormat);
        FormData fdlOutputFormat = new FormData();
        fdlOutputFormat.left = new FormAttachment(0, 0);
        fdlOutputFormat.top = new FormAttachment((Control)this.wLimit, this.margin);
        fdlOutputFormat.right = new FormAttachment(this.middle, -this.margin);
        wlOutputFormat.setLayoutData((Object)fdlOutputFormat);
        this.wOutputFormat = new CCombo((Composite)wFileConf, 2056);
        this.wOutputFormat.setText(BaseMessages.getString(PKG, (String)"TikaDialog.OutputFormat.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOutputFormat);
        this.wOutputFormat.setItems(tikaOutput.getFileOutputTypeCodes().keySet().toArray(new String[0]));
        FormData fdOutputFormat = new FormData();
        fdOutputFormat.left = new FormAttachment(this.middle, 0);
        fdOutputFormat.top = new FormAttachment((Control)this.wLimit, this.margin);
        fdOutputFormat.right = new FormAttachment(100, 0);
        this.wOutputFormat.setLayoutData((Object)fdOutputFormat);
        FormData fdFileConf = new FormData();
        fdFileConf.left = new FormAttachment(0, this.margin);
        fdFileConf.top = new FormAttachment(0, this.margin);
        fdFileConf.right = new FormAttachment(100, -this.margin);
        wFileConf.setLayoutData((Object)fdFileConf);
        Group wAddFileResultGroup = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wAddFileResultGroup);
        wAddFileResultGroup.setText(BaseMessages.getString(PKG, (String)"TikaDialog.wAddFileResult.Label", (String[])new String[0]));
        FormLayout addFileResultGroupLayout = new FormLayout();
        addFileResultGroupLayout.marginWidth = 10;
        addFileResultGroupLayout.marginHeight = 10;
        wAddFileResultGroup.setLayout((Layout)addFileResultGroupLayout);
        this.wlAddResult = new Label((Composite)wAddFileResultGroup, 131072);
        this.wlAddResult.setText(BaseMessages.getString(PKG, (String)"TikaDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment(0, this.margin);
        fdlAddResult.right = new FormAttachment(this.middle, -this.margin);
        this.wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wAddFileResultGroup, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"TikaDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(this.middle, 0);
        fdAddResult.top = new FormAttachment((Control)this.wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        FormData fdAddFileResult = new FormData();
        fdAddFileResult.left = new FormAttachment(0, this.margin);
        fdAddFileResult.top = new FormAttachment((Control)wFileConf, this.margin);
        fdAddFileResult.right = new FormAttachment(100, -this.margin);
        wAddFileResultGroup.setLayoutData((Object)fdAddFileResult);
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        this.addOutputFieldsTab();
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TikaDialog.this.wFilenameList.add(new String[]{TikaDialog.this.wFilename.getText(), TikaDialog.this.wFilemask.getText(), TikaDialog.this.wExcludeFilemask.getText(), "Y", "Y"});
                TikaDialog.this.wFilename.setText("");
                TikaDialog.this.wFilemask.setText("");
                TikaDialog.this.wExcludeFilemask.setText("");
                TikaDialog.this.wFilenameList.removeEmptyRows();
                TikaDialog.this.wFilenameList.setRowNums();
                TikaDialog.this.wFilenameList.optWidth(true);
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = TikaDialog.this.wFilenameList.getSelectionIndices();
                TikaDialog.this.wFilenameList.remove(idx);
                TikaDialog.this.wFilenameList.removeEmptyRows();
                TikaDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = TikaDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = TikaDialog.this.wFilenameList.getItem(idx);
                    TikaDialog.this.wFilename.setText(string[0]);
                    TikaDialog.this.wFilemask.setText(string[1]);
                    TikaDialog.this.wExcludeFilemask.setText(string[2]);
                    TikaDialog.this.wFilenameList.remove(idx);
                }
                TikaDialog.this.wFilenameList.removeEmptyRows();
                TikaDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TikaMeta tikaMeta = new TikaMeta();
                    TikaDialog.this.getInfo(tikaMeta);
                    FileInputList fileInputList = tikaMeta.getFiles(TikaDialog.this.variables);
                    String[] files = fileInputList.getFileStrings();
                    if (files != null && files.length > 0) {
                        EnterSelectionDialog esd = new EnterSelectionDialog(TikaDialog.this.shell, files, BaseMessages.getString(PKG, (String)"TikaDialog.FilesReadSelection.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TikaDialog.FilesReadSelection.DialogMessage", (String[])new String[0]));
                        esd.setViewOnly();
                        esd.open();
                    } else {
                        MessageBox mb = new MessageBox(TikaDialog.this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"TikaDialog.NoFileFound.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(TikaDialog.this.shell, BaseMessages.getString(PKG, (String)"TikaDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TikaDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), ex);
                }
            }
        });
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.wFilename.getText()));
        this.wbbFilename.addListener(13, e -> {
            if (!StringUtils.isEmpty((String)this.wFilemask.getText()) || !StringUtils.isEmpty((String)this.wExcludeFilemask.getText())) {
                BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables);
            } else {
                BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
            }
        });
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData(this.input);
        this.enableFields();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setDynamicFilenameField() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wFilenameField.getText();
                this.wFilenameField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wFilenameField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wFilenameField.setText(field);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TikaDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TikaDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void enableFields() {
        this.wlFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wbbFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wbaFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wlFilemask.setEnabled(!this.wFilenameInField.getSelection());
        this.wFilemask.setEnabled(!this.wFilenameInField.getSelection());
        this.wlExcludeFilemask.setEnabled(!this.wFilenameInField.getSelection());
        this.wExcludeFilemask.setEnabled(!this.wFilenameInField.getSelection());
        this.wlFilenameList.setEnabled(!this.wFilenameInField.getSelection());
        this.wbdFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wbeFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wbShowFiles.setEnabled(!this.wFilenameInField.getSelection());
        this.wlFilenameList.setEnabled(!this.wFilenameInField.getSelection());
        this.wFilenameList.setEnabled(!this.wFilenameInField.getSelection());
        if (this.wFilenameInField.getSelection()) {
            this.wEncoding.setEnabled(false);
            this.wlEncoding.setEnabled(false);
        } else {
            this.wEncoding.setEnabled(true);
            this.wlEncoding.setEnabled(true);
        }
        this.wAddResult.setEnabled(!this.wFilenameInField.getSelection());
        this.wlAddResult.setEnabled(!this.wFilenameInField.getSelection());
        this.wLimit.setEnabled(!this.wFilenameInField.getSelection());
        this.wPreview.setEnabled(!this.wFilenameInField.getSelection());
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            String encoding = this.wEncoding.getText();
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            if (!StringUtils.isEmpty((String)encoding)) {
                this.wEncoding.setText(encoding);
            }
        }
    }

    public void getData(TikaMeta meta) {
        this.wFilenameList.removeAll();
        for (TikaFile file : meta.getFiles()) {
            this.wFilenameList.add(new String[]{file.getName(), file.getMask(), file.getExcludeMask(), file.isRequired() ? "Y" : "N", file.isIncludingSubFolders() ? "Y" : "N"});
        }
        this.wFilenameList.optimizeTableView();
        this.wAddResult.setSelection(meta.isAddingResultFile());
        this.wIgnoreEmptyFile.setSelection(meta.isIgnoreEmptyFile());
        this.wFilenameInField.setSelection(meta.isFileInField());
        this.wFilenameField.setText(Const.NVL((String)meta.getDynamicFilenameField(), (String)""));
        this.wLimit.setText("" + meta.getRowLimit());
        this.wEncoding.setText(Const.NVL((String)meta.getEncoding(), (String)""));
        this.wOutputFormat.setText(meta.getOutputFormat() != null ? meta.getOutputFormat() : "Plain text");
        this.wContentFieldName.setText(Const.NVL((String)meta.getContentFieldName(), (String)""));
        this.wFileSizeFieldName.setText(Const.NVL((String)meta.getFileSizeFieldName(), (String)""));
        this.wMetadataFieldName.setText(Const.NVL((String)meta.getMetadataFieldName(), (String)""));
        this.wInclFilenameField.setText(Const.NVL((String)meta.getFilenameField(), (String)""));
        this.wRowNumField.setText(Const.NVL((String)meta.getRowNumberField(), (String)""));
        this.wShortFileFieldName.setText(Const.NVL((String)meta.getShortFileFieldName(), (String)""));
        this.wPathFieldName.setText(Const.NVL((String)meta.getPathFieldName(), (String)""));
        this.wIsHiddenName.setText(Const.NVL((String)meta.getHiddenFieldName(), (String)""));
        this.wLastModificationTimeName.setText(Const.NVL((String)meta.getLastModificationTimeFieldName(), (String)""));
        this.wUriName.setText(Const.NVL((String)meta.getUriFieldName(), (String)""));
        this.wRootUriName.setText(Const.NVL((String)meta.getRootUriNameFieldName(), (String)""));
        this.wExtensionFieldName.setText(Const.NVL((String)meta.getExtensionFieldName(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TikaDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TikaDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(TikaMeta in) throws HopException {
        this.transformName = this.wTransformName.getText();
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        in.setEncoding(this.wEncoding.getText());
        in.setOutputFormat(this.wOutputFormat.getText());
        in.setAddingResultFile(this.wAddResult.getSelection());
        in.setIgnoreEmptyFile(this.wIgnoreEmptyFile.getSelection());
        in.setFileInField(this.wFilenameInField.getSelection());
        in.setDynamicFilenameField(this.wFilenameField.getText());
        List fileItems = this.wFilenameList.getNonEmptyItems();
        in.getFiles().clear();
        for (TableItem item : fileItems) {
            TikaFile file = new TikaFile();
            int col = 1;
            file.setName(item.getText(col++));
            file.setMask(item.getText(col++));
            file.setExcludeMask(item.getText(col++));
            file.setRequired("Y".equalsIgnoreCase(item.getText(col++)));
            file.setIncludingSubFolders("Y".equalsIgnoreCase(item.getText(col)));
            in.getFiles().add(file);
        }
        in.setContentFieldName(this.wContentFieldName.getText());
        in.setFileSizeFieldName(this.wFileSizeFieldName.getText());
        in.setMetadataFieldName(this.wMetadataFieldName.getText());
        in.setFilenameField(this.wInclFilenameField.getText());
        in.setRowNumberField(this.wRowNumField.getText());
        in.setShortFileFieldName(this.wShortFileFieldName.getText());
        in.setPathFieldName(this.wPathFieldName.getText());
        in.setHiddenFieldName(this.wIsHiddenName.getText());
        in.setLastModificationTimeFieldName(this.wLastModificationTimeName.getText());
        in.setUriFieldName(this.wUriName.getText());
        in.setRootUriNameFieldName(this.wRootUriName.getText());
        in.setExtensionFieldName(this.wExtensionFieldName.getText());
    }

    private void preview() {
        try {
            TikaMeta oneMeta = new TikaMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.metadataProvider, (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"TikaDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TikaDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Pipeline pipeline = progressDialog.getPipeline();
                    String loggingText = progressDialog.getLoggingText();
                    if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TikaDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TikaDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void addOutputFieldsTab() {
        CTabItem wOutputFieldsTab = new CTabItem(this.wTabFolder, 0);
        wOutputFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOutputFieldsTab.setText(BaseMessages.getString(PKG, (String)"TikaDialog.OutputFieldsTab.TabTitle", (String[])new String[0]));
        Composite wOutputFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wOutputFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wOutputFieldsComp.setLayout((Layout)fieldsLayout);
        Label wlContentFieldName = new Label(wOutputFieldsComp, 131072);
        wlContentFieldName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.ContentFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlContentFieldName);
        FormData fdlContentFieldName = new FormData();
        fdlContentFieldName.left = new FormAttachment(0, 0);
        fdlContentFieldName.top = new FormAttachment(0, this.margin);
        fdlContentFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlContentFieldName.setLayoutData((Object)fdlContentFieldName);
        this.wContentFieldName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wContentFieldName);
        FormData fdContentFieldName = new FormData();
        fdContentFieldName.left = new FormAttachment(this.middle, 0);
        fdContentFieldName.right = new FormAttachment(100, -this.margin);
        fdContentFieldName.top = new FormAttachment((Control)wlContentFieldName, 0, 0x1000000);
        this.wContentFieldName.setLayoutData((Object)fdContentFieldName);
        TextVar lastControl = this.wContentFieldName;
        Label wlFileSizeFieldName = new Label(wOutputFieldsComp, 131072);
        wlFileSizeFieldName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.FileSizeFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileSizeFieldName);
        FormData fdlFileSizeFieldName = new FormData();
        fdlFileSizeFieldName.left = new FormAttachment(0, 0);
        fdlFileSizeFieldName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlFileSizeFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlFileSizeFieldName.setLayoutData((Object)fdlFileSizeFieldName);
        this.wFileSizeFieldName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wFileSizeFieldName);
        FormData fdFileSizeFieldName = new FormData();
        fdFileSizeFieldName.left = new FormAttachment(this.middle, 0);
        fdFileSizeFieldName.right = new FormAttachment(100, -this.margin);
        fdFileSizeFieldName.top = new FormAttachment((Control)wlFileSizeFieldName, 0, 0x1000000);
        this.wFileSizeFieldName.setLayoutData((Object)fdFileSizeFieldName);
        lastControl = this.wFileSizeFieldName;
        Label wlMetadataFieldName = new Label(wOutputFieldsComp, 131072);
        wlMetadataFieldName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.MetadataFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMetadataFieldName);
        FormData fdlMetadataFieldName = new FormData();
        fdlMetadataFieldName.left = new FormAttachment(0, 0);
        fdlMetadataFieldName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlMetadataFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlMetadataFieldName.setLayoutData((Object)fdlMetadataFieldName);
        this.wMetadataFieldName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wMetadataFieldName);
        FormData fdMetadataFieldName = new FormData();
        fdMetadataFieldName.left = new FormAttachment(this.middle, 0);
        fdMetadataFieldName.right = new FormAttachment(100, -this.margin);
        fdMetadataFieldName.top = new FormAttachment((Control)wlMetadataFieldName, 0, 0x1000000);
        this.wMetadataFieldName.setLayoutData((Object)fdMetadataFieldName);
        lastControl = this.wMetadataFieldName;
        Label wlInclFilenameField = new Label(wOutputFieldsComp, 131072);
        wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"TikaDialog.InclFilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclFilenameField);
        FormData fdlInclFilenameField = new FormData();
        fdlInclFilenameField.left = new FormAttachment(0, 0);
        fdlInclFilenameField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlInclFilenameField.right = new FormAttachment(this.middle, -this.margin);
        wlInclFilenameField.setLayoutData((Object)fdlInclFilenameField);
        this.wInclFilenameField = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wInclFilenameField);
        FormData fdInclFilenameField = new FormData();
        fdInclFilenameField.left = new FormAttachment(this.middle, 0);
        fdInclFilenameField.top = new FormAttachment((Control)wlInclFilenameField, 0, 0x1000000);
        fdInclFilenameField.right = new FormAttachment(100, -this.margin);
        this.wInclFilenameField.setLayoutData((Object)fdInclFilenameField);
        lastControl = this.wInclFilenameField;
        Label wlRowNumField = new Label(wOutputFieldsComp, 131072);
        wlRowNumField.setText(BaseMessages.getString(PKG, (String)"TikaDialog.RowNum.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRowNumField);
        FormData fdlRowNumField = new FormData();
        fdlRowNumField.left = new FormAttachment(0, 0);
        fdlRowNumField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlRowNumField.right = new FormAttachment(this.middle, -this.margin);
        wlRowNumField.setLayoutData((Object)fdlRowNumField);
        this.wRowNumField = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wRowNumField);
        FormData fdRowNumField = new FormData();
        fdRowNumField.left = new FormAttachment(this.middle, 0);
        fdRowNumField.right = new FormAttachment(100, -this.margin);
        fdRowNumField.top = new FormAttachment((Control)wlRowNumField, 0, 0x1000000);
        this.wRowNumField.setLayoutData((Object)fdRowNumField);
        lastControl = this.wRowNumField;
        Label wlShortFileFieldName = new Label(wOutputFieldsComp, 131072);
        wlShortFileFieldName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.ShortFileFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlShortFileFieldName);
        FormData fdlShortFileFieldName = new FormData();
        fdlShortFileFieldName.left = new FormAttachment(0, 0);
        fdlShortFileFieldName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlShortFileFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlShortFileFieldName.setLayoutData((Object)fdlShortFileFieldName);
        this.wShortFileFieldName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wShortFileFieldName);
        FormData fdShortFileFieldName = new FormData();
        fdShortFileFieldName.left = new FormAttachment(this.middle, 0);
        fdShortFileFieldName.right = new FormAttachment(100, -this.margin);
        fdShortFileFieldName.top = new FormAttachment((Control)wlShortFileFieldName, 0, 0x1000000);
        this.wShortFileFieldName.setLayoutData((Object)fdShortFileFieldName);
        lastControl = this.wShortFileFieldName;
        Label wlExtensionFieldName = new Label(wOutputFieldsComp, 131072);
        wlExtensionFieldName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.ExtensionFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExtensionFieldName);
        FormData fdlExtensionFieldName = new FormData();
        fdlExtensionFieldName.left = new FormAttachment(0, 0);
        fdlExtensionFieldName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExtensionFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlExtensionFieldName.setLayoutData((Object)fdlExtensionFieldName);
        this.wExtensionFieldName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wExtensionFieldName);
        FormData fdExtensionFieldName = new FormData();
        fdExtensionFieldName.left = new FormAttachment(this.middle, 0);
        fdExtensionFieldName.right = new FormAttachment(100, -this.margin);
        fdExtensionFieldName.top = new FormAttachment((Control)wlExtensionFieldName, 0, 0x1000000);
        this.wExtensionFieldName.setLayoutData((Object)fdExtensionFieldName);
        lastControl = this.wExtensionFieldName;
        Label wlPathFieldName = new Label(wOutputFieldsComp, 131072);
        wlPathFieldName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.PathFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPathFieldName);
        FormData fdlPathFieldName = new FormData();
        fdlPathFieldName.left = new FormAttachment(0, 0);
        fdlPathFieldName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlPathFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlPathFieldName.setLayoutData((Object)fdlPathFieldName);
        this.wPathFieldName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wPathFieldName);
        FormData fdPathFieldName = new FormData();
        fdPathFieldName.left = new FormAttachment(this.middle, 0);
        fdPathFieldName.right = new FormAttachment(100, -this.margin);
        fdPathFieldName.top = new FormAttachment((Control)wlPathFieldName, 0, 0x1000000);
        this.wPathFieldName.setLayoutData((Object)fdPathFieldName);
        lastControl = this.wPathFieldName;
        Label wlIsHiddenName = new Label(wOutputFieldsComp, 131072);
        wlIsHiddenName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.IsHiddenName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIsHiddenName);
        FormData fdlIsHiddenName = new FormData();
        fdlIsHiddenName.left = new FormAttachment(0, 0);
        fdlIsHiddenName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlIsHiddenName.right = new FormAttachment(this.middle, -this.margin);
        wlIsHiddenName.setLayoutData((Object)fdlIsHiddenName);
        this.wIsHiddenName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wIsHiddenName);
        FormData fdIsHiddenName = new FormData();
        fdIsHiddenName.left = new FormAttachment(this.middle, 0);
        fdIsHiddenName.right = new FormAttachment(100, -this.margin);
        fdIsHiddenName.top = new FormAttachment((Control)wlIsHiddenName, 0, 0x1000000);
        this.wIsHiddenName.setLayoutData((Object)fdIsHiddenName);
        lastControl = this.wIsHiddenName;
        Label wlLastModificationTimeName = new Label(wOutputFieldsComp, 131072);
        wlLastModificationTimeName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.LastModificationTimeName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLastModificationTimeName);
        FormData fdlLastModificationTimeName = new FormData();
        fdlLastModificationTimeName.left = new FormAttachment(0, 0);
        fdlLastModificationTimeName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlLastModificationTimeName.right = new FormAttachment(this.middle, -this.margin);
        wlLastModificationTimeName.setLayoutData((Object)fdlLastModificationTimeName);
        this.wLastModificationTimeName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wLastModificationTimeName);
        FormData fdLastModificationTimeName = new FormData();
        fdLastModificationTimeName.left = new FormAttachment(this.middle, 0);
        fdLastModificationTimeName.right = new FormAttachment(100, -this.margin);
        fdLastModificationTimeName.top = new FormAttachment((Control)wlLastModificationTimeName, 0, 0x1000000);
        this.wLastModificationTimeName.setLayoutData((Object)fdLastModificationTimeName);
        lastControl = this.wLastModificationTimeName;
        Label wlUriName = new Label(wOutputFieldsComp, 131072);
        wlUriName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.UriName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUriName);
        FormData fdlUriName = new FormData();
        fdlUriName.left = new FormAttachment(0, 0);
        fdlUriName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlUriName.right = new FormAttachment(this.middle, -this.margin);
        wlUriName.setLayoutData((Object)fdlUriName);
        this.wUriName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wUriName);
        FormData fdUriName = new FormData();
        fdUriName.left = new FormAttachment(this.middle, 0);
        fdUriName.right = new FormAttachment(100, -this.margin);
        fdUriName.top = new FormAttachment((Control)wlUriName, 0, 0x1000000);
        this.wUriName.setLayoutData((Object)fdUriName);
        lastControl = this.wUriName;
        Label wlRootUriName = new Label(wOutputFieldsComp, 131072);
        wlRootUriName.setText(BaseMessages.getString(PKG, (String)"TikaDialog.RootUriName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRootUriName);
        FormData fdlRootUriName = new FormData();
        fdlRootUriName.left = new FormAttachment(0, 0);
        fdlRootUriName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlRootUriName.right = new FormAttachment(this.middle, -this.margin);
        wlRootUriName.setLayoutData((Object)fdlRootUriName);
        this.wRootUriName = new TextVar(this.variables, wOutputFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wRootUriName);
        FormData fdRootUriName = new FormData();
        fdRootUriName.left = new FormAttachment(this.middle, 0);
        fdRootUriName.right = new FormAttachment(100, -this.margin);
        fdRootUriName.top = new FormAttachment((Control)wlRootUriName, 0, 0x1000000);
        this.wRootUriName.setLayoutData((Object)fdRootUriName);
        lastControl = this.wRootUriName;
        FormData fdOutputFieldsComp = new FormData();
        fdOutputFieldsComp.left = new FormAttachment(0, 0);
        fdOutputFieldsComp.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdOutputFieldsComp.right = new FormAttachment(100, 0);
        fdOutputFieldsComp.bottom = new FormAttachment(100, 0);
        wOutputFieldsComp.setLayoutData((Object)fdOutputFieldsComp);
        wOutputFieldsComp.layout();
        wOutputFieldsTab.setControl((Control)wOutputFieldsComp);
    }
}

