/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryRowDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryRowDescriptorImpl;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ColumnStatisticsCollector;
import org.apache.ignite.internal.processors.query.stat.GatherStatisticCancelException;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsRepository;
import org.apache.ignite.internal.processors.query.stat.LocalStatisticsGatheringContext;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GatherPartitionStatistics
implements Callable<ObjectPartitionStatisticsImpl> {
    private static final int CANCELLED_CHECK_INTERVAL = 100;
    private final IgniteStatisticsRepository statRepo;
    private final int partId;
    private final LocalStatisticsGatheringContext gathCtx;
    private final IgniteLogger log;
    private long time;

    public GatherPartitionStatistics(IgniteStatisticsRepository statRepo, LocalStatisticsGatheringContext gathCtx, int partId, IgniteLogger log) {
        this.statRepo = statRepo;
        this.partId = partId;
        this.gathCtx = gathCtx;
        this.log = log;
    }

    public int partition() {
        return this.partId;
    }

    public LocalStatisticsGatheringContext context() {
        return this.gathCtx;
    }

    @Override
    public ObjectPartitionStatisticsImpl call() {
        GridCacheContext<?, ?> cctx;
        this.time = U.currentTimeMillis();
        if (this.gathCtx.cancelled()) {
            throw new GatherStatisticCancelException();
        }
        GridCacheContext<?, ?> gridCacheContext = cctx = this.gathCtx.cacheContextInfo() != null ? this.gathCtx.cacheContextInfo().cacheContext() : null;
        if (cctx == null || !cctx.gate().enterIfNotStopped()) {
            throw new GatherStatisticCancelException();
        }
        try {
            ObjectPartitionStatisticsImpl objectPartitionStatisticsImpl = this.processPartition(cctx);
            return objectPartitionStatisticsImpl;
        }
        finally {
            cctx.gate().leave();
        }
    }

    private ObjectPartitionStatisticsImpl processPartition(GridCacheContext<?, ?> cctx) {
        ObjectPartitionStatisticsImpl partStat = this.statRepo.getLocalPartitionStatistics(this.gathCtx.configuration().key(), this.partId);
        Map<String, StatisticsColumnConfiguration> colsToCollect = this.getColumnsToCollect(partStat);
        Set<String> colsToRemove = this.getColumnsToRemove(partStat);
        if (F.isEmpty(colsToCollect)) {
            return this.fixExisting(partStat, colsToRemove);
        }
        return this.recollectPartition(cctx, partStat, colsToCollect, colsToRemove);
    }

    private ObjectPartitionStatisticsImpl fixExisting(ObjectPartitionStatisticsImpl partStat, Set<String> colsToRemove) {
        ObjectPartitionStatisticsImpl res;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Existing parititon statistics fit to configuration requirements. Skipping recollection for " + this.gathCtx.configuration().key() + "[" + this.partId + "].");
        }
        if (F.isEmpty(colsToRemove)) {
            res = partStat;
        } else {
            HashMap<String, ColumnStatistics> allCols = new HashMap<String, ColumnStatistics>(partStat.columnsStatistics());
            for (String col : colsToRemove) {
                allCols.remove(col);
            }
            res = new ObjectPartitionStatisticsImpl(partStat.partId(), this.getRowCount(allCols), partStat.updCnt(), allCols);
            assert (!allCols.isEmpty()) : "No columns left after fixing existing partition statistics.";
            this.statRepo.replaceLocalPartitionStatistics(this.gathCtx.configuration().key(), res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectPartitionStatisticsImpl recollectPartition(GridCacheContext<?, ?> cctx, ObjectPartitionStatisticsImpl partStat, Map<String, StatisticsColumnConfiguration> colsToCollect, Set<String> colsToRemove) {
        ObjectPartitionStatisticsImpl res;
        AffinityTopologyVersion topVer;
        CacheGroupContext grp = cctx.group();
        GridDhtPartitionTopology top = grp.topology();
        GridDhtLocalPartition locPart = top.localPartition(this.partId, topVer = top.readyTopologyVersion(), false);
        if (locPart == null) {
            throw new GatherStatisticCancelException();
        }
        boolean reserved = locPart.reserve();
        GridQueryTypeDescriptor tbl = this.gathCtx.table();
        try {
            if (!reserved || locPart.state() != GridDhtPartitionState.OWNING) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition not owning. Need to retry [part=" + this.partId + ", tbl=" + tbl.tableName() + "]");
                }
                throw new GatherStatisticCancelException();
            }
            List<T2<Integer, String>> cols = IgniteStatisticsHelper.filterColumns(tbl, colsToCollect.keySet());
            ArrayList<ColumnStatisticsCollector> collectors = new ArrayList<ColumnStatisticsCollector>();
            for (T2<Integer, String> col : cols) {
                Integer colId = (Integer)col.getKey();
                String colName = (String)col.getValue();
                long colCfgVer = colsToCollect.get(colName).version();
                Class<?> colCls = tbl.fields().get(colName);
                collectors.add(new ColumnStatisticsCollector(colId, colName, colCls, colCfgVer));
            }
            try {
                int checkInt = 100;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Start partition scan [part=" + this.partId + ", tbl=" + tbl.tableName() + "]");
                }
                GridQueryRowDescriptorImpl rowDesc = new GridQueryRowDescriptorImpl(this.gathCtx.cacheContextInfo(), tbl);
                for (CacheDataRow row : grp.offheap().cachePartitionIterator(this.gathCtx.cacheContextInfo().cacheId(), this.partId, false)) {
                    if (--checkInt == 0) {
                        if (this.gathCtx.future().isCancelled()) {
                            throw new GatherStatisticCancelException();
                        }
                        checkInt = 100;
                    }
                    if (!tbl.matchType(row.value()) || this.wasExpired(row)) continue;
                    for (ColumnStatisticsCollector colStat : collectors) {
                        colStat.add(this.getValue(cctx, rowDesc, row, colStat));
                    }
                }
            }
            catch (IgniteCheckedException e) {
                this.log.warning(String.format("Unable to collect partition level statistics by %s.%s:%d due to %s", tbl.schemaName(), tbl.tableName(), this.partId, e.getMessage()));
                throw new IgniteException("Unable to collect partition level statistics", e);
            }
            Map<String, ColumnStatistics> colStats = collectors.stream().collect(Collectors.toMap(ColumnStatisticsCollector::columnName, ColumnStatisticsCollector::finish));
            if (partStat != null) {
                for (Map.Entry<String, ColumnStatistics> oldColStat : partStat.columnsStatistics().entrySet()) {
                    if (colsToRemove.contains(oldColStat.getKey())) continue;
                    colStats.putIfAbsent(oldColStat.getKey(), oldColStat.getValue());
                }
            }
            res = new ObjectPartitionStatisticsImpl(this.partId, this.getRowCount(colStats), locPart.updateCounter(), colStats);
        }
        finally {
            if (reserved) {
                locPart.release();
            }
        }
        this.statRepo.replaceLocalPartitionStatistics(this.gathCtx.configuration().key(), res);
        if (this.gathCtx.configuration().columns().size() == colsToCollect.size()) {
            this.statRepo.refreshObsolescence(this.gathCtx.configuration().key(), this.partId);
        }
        return res;
    }

    private Object getValue(GridCacheContext<?, ?> cctx, GridQueryRowDescriptor desc, CacheDataRow row, ColumnStatisticsCollector coll) {
        if (desc.isKeyColumn(coll.columnId())) {
            return this.unwrap(cctx, row.key(), desc.type().keyClass());
        }
        if (desc.isValueColumn(coll.columnId())) {
            return this.unwrap(cctx, row.value(), desc.type().valueClass());
        }
        Object val = desc.getFieldValue(row.key(), row.value(), coll.columnId() - 2);
        return this.unwrap(cctx, val, coll.columnType());
    }

    private Object unwrap(GridCacheContext<?, ?> cctx, Object val, Class<?> cls) {
        if (val == null) {
            return null;
        }
        if (val instanceof CacheObject && QueryUtils.isSqlType(cls)) {
            return ((CacheObject)val).value(cctx.cacheObjectContext(), false);
        }
        return val;
    }

    private long getRowCount(Map<String, ColumnStatistics> cols) {
        long res = 0L;
        for (ColumnStatistics colStat : cols.values()) {
            if (res >= colStat.total()) continue;
            res = colStat.total();
        }
        return res;
    }

    private Map<String, StatisticsColumnConfiguration> getColumnsToCollect(ObjectPartitionStatisticsImpl partStat) {
        if (partStat == null || this.gathCtx.forceRecollect()) {
            return this.gathCtx.configuration().columns();
        }
        HashMap<String, StatisticsColumnConfiguration> res = new HashMap<String, StatisticsColumnConfiguration>();
        for (StatisticsColumnConfiguration colStatCfg : this.gathCtx.configuration().columns().values()) {
            ColumnStatistics colStat = partStat.columnStatistics(colStatCfg.name());
            if (colStat != null && colStatCfg.version() <= colStat.version()) continue;
            res.put(colStatCfg.name(), colStatCfg);
        }
        return res;
    }

    private Set<String> getColumnsToRemove(@Nullable ObjectPartitionStatisticsImpl partStat) {
        if (partStat == null) {
            return Collections.emptySet();
        }
        HashSet<String> res = new HashSet<String>();
        Map<String, StatisticsColumnConfiguration> colCfg = this.gathCtx.configuration().columns();
        for (String col : partStat.columnsStatistics().keySet()) {
            if (colCfg.containsKey(col)) continue;
            res.add(col);
        }
        return res;
    }

    private boolean wasExpired(CacheDataRow row) {
        return row.expireTime() > 0L && row.expireTime() <= this.time;
    }
}

