/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.managers.eventstorage.HighPriorityListener;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationMetricsListener;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionClientPool;
import org.jetbrains.annotations.Nullable;

public class CommunicationDiscoveryEventListener
implements GridLocalEventListener,
HighPriorityListener {
    private final ConnectionClientPool clientPool;
    @Nullable
    private volatile TcpCommunicationMetricsListener metricsLsnr;

    public CommunicationDiscoveryEventListener(ConnectionClientPool clientPool, TcpCommunicationMetricsListener metricsLsnr) {
        this.clientPool = clientPool;
        this.metricsLsnr = metricsLsnr;
    }

    @Override
    public void onEvent(Event evt) {
        assert (evt instanceof DiscoveryEvent) : evt;
        assert (evt.type() == 11 || evt.type() == 12);
        ClusterNode node = ((DiscoveryEvent)evt).eventNode();
        this.onNodeLeft(node.consistentId(), node.id());
    }

    @Override
    public int order() {
        return 0;
    }

    private void onNodeLeft(Object consistentId, UUID nodeId) {
        assert (nodeId != null);
        this.metricsLsnr.onNodeLeft(consistentId);
        this.clientPool.onNodeLeft(nodeId);
    }

    public void metricsListener(@Nullable TcpCommunicationMetricsListener metricsLsnr) {
        this.metricsLsnr = metricsLsnr;
    }
}

