/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.transactions.TransactionChanges;
import org.apache.ignite.internal.util.lang.GridCursor;

class KeyFilteringCursor<R>
implements GridCursor<R> {
    private final GridCursor<? extends R> cursor;
    private final TransactionChanges<?> txChanges;
    private final Function<R, KeyCacheObject> toKey;

    KeyFilteringCursor(GridCursor<? extends R> cursor, TransactionChanges<?> txChanges, Function<R, KeyCacheObject> toKey) {
        this.cursor = cursor;
        this.txChanges = txChanges;
        this.toKey = toKey;
    }

    public boolean next() throws IgniteCheckedException {
        Object cur;
        do {
            if (!this.cursor.next()) {
                return false;
            }
            cur = this.cursor.get();
        } while (!this.txChanges.changedKeysEmpty() && this.txChanges.remove(this.toKey.apply(cur)));
        return true;
    }

    public R get() throws IgniteCheckedException {
        return (R)this.cursor.get();
    }
}

