/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite.internal.sql.engine.exec.mapping.FragmentDescription;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequest;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequestBuilder;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequestSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class QueryStartRequestImpl
implements QueryStartRequest,
Cloneable {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 0;
    @IgniteToStringInclude
    private final int catalogVersion;
    @IgniteToStringInclude
    private final int executionToken;
    @IgniteToStringInclude
    private FragmentDescription fragmentDescription;
    private byte[] fragmentDescriptionByteArray;
    @IgniteToStringInclude
    private final long fragmentId;
    @IgniteToStringInclude
    private final HybridTimestamp operationTime;
    @IgniteToStringInclude
    private Object[] parameters;
    private byte[] parametersByteArray;
    @IgniteToStringInclude
    private final UUID queryId;
    @IgniteToStringInclude
    private final String root;
    @IgniteToStringInclude
    private final String timeZoneId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private TxAttributes txAttributes;
    private byte[] txAttributesByteArray;

    private QueryStartRequestImpl(int catalogVersion, int executionToken, FragmentDescription fragmentDescription, byte[] fragmentDescriptionByteArray, long fragmentId, HybridTimestamp operationTime, Object[] parameters, byte[] parametersByteArray, UUID queryId, String root, String timeZoneId, HybridTimestamp timestamp, TxAttributes txAttributes, byte[] txAttributesByteArray) {
        this.catalogVersion = catalogVersion;
        this.executionToken = executionToken;
        if (fragmentDescription == null && fragmentDescriptionByteArray == null) {
            throw new NullPointerException("fragmentDescription is not marked @Nullable");
        }
        this.fragmentDescription = fragmentDescription;
        this.fragmentDescriptionByteArray = fragmentDescriptionByteArray;
        this.fragmentId = fragmentId;
        this.operationTime = operationTime;
        if (parameters == null && parametersByteArray == null) {
            throw new NullPointerException("parameters is not marked @Nullable");
        }
        this.parameters = parameters;
        this.parametersByteArray = parametersByteArray;
        this.queryId = queryId;
        this.root = root;
        this.timeZoneId = timeZoneId;
        this.timestamp = timestamp;
        if (txAttributes == null && txAttributesByteArray == null) {
            throw new NullPointerException("txAttributes is not marked @Nullable");
        }
        this.txAttributes = txAttributes;
        this.txAttributesByteArray = txAttributesByteArray;
    }

    @Override
    public int catalogVersion() {
        return this.catalogVersion;
    }

    @Override
    public int executionToken() {
        return this.executionToken;
    }

    byte[] fragmentDescriptionByteArray() {
        return this.fragmentDescriptionByteArray;
    }

    @Override
    public FragmentDescription fragmentDescription() {
        return this.fragmentDescription;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public HybridTimestamp operationTime() {
        return this.operationTime;
    }

    byte[] parametersByteArray() {
        return this.parametersByteArray;
    }

    @Override
    public Object[] parameters() {
        return this.parameters;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    @Override
    public String root() {
        return this.root;
    }

    @Override
    public String timeZoneId() {
        return this.timeZoneId;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    byte[] txAttributesByteArray() {
        return this.txAttributesByteArray;
    }

    @Override
    public TxAttributes txAttributes() {
        return this.txAttributes;
    }

    public MessageSerializer serializer() {
        return QueryStartRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(QueryStartRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryStartRequestImpl otherMessage = (QueryStartRequestImpl)other;
        return Objects.equals(this.fragmentDescription, otherMessage.fragmentDescription) && Objects.equals(this.operationTime, otherMessage.operationTime) && Objects.equals(this.queryId, otherMessage.queryId) && Objects.equals(this.root, otherMessage.root) && Objects.equals(this.timeZoneId, otherMessage.timeZoneId) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.txAttributes, otherMessage.txAttributes) && Arrays.equals(this.parameters, otherMessage.parameters) && this.catalogVersion == otherMessage.catalogVersion && this.executionToken == otherMessage.executionToken && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.catalogVersion, this.executionToken, this.fragmentId, this.fragmentDescription, this.operationTime, this.queryId, this.root, this.timeZoneId, this.timestamp, this.txAttributes);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public QueryStartRequestImpl clone() {
        try {
            return (QueryStartRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static QueryStartRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject fragmentDescriptionByteArraymo = marshaller.marshal((Object)this.fragmentDescription);
        usedDescriptors.addAll((IntCollection)fragmentDescriptionByteArraymo.usedDescriptorIds());
        this.fragmentDescriptionByteArray = fragmentDescriptionByteArraymo.bytes();
        MarshalledObject parametersByteArraymo = marshaller.marshal((Object)this.parameters);
        usedDescriptors.addAll((IntCollection)parametersByteArraymo.usedDescriptorIds());
        this.parametersByteArray = parametersByteArraymo.bytes();
        MarshalledObject txAttributesByteArraymo = marshaller.marshal((Object)this.txAttributes);
        usedDescriptors.addAll((IntCollection)txAttributesByteArraymo.usedDescriptorIds());
        this.txAttributesByteArray = txAttributesByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.fragmentDescription = (FragmentDescription)marshaller.unmarshal(this.fragmentDescriptionByteArray, descriptorsObj);
        this.fragmentDescriptionByteArray = null;
        this.parameters = (Object[])marshaller.unmarshal(this.parametersByteArray, descriptorsObj);
        this.parametersByteArray = null;
        this.txAttributes = (TxAttributes)marshaller.unmarshal(this.txAttributesByteArray, descriptorsObj);
        this.txAttributesByteArray = null;
    }

    private static class Builder
    implements QueryStartRequestBuilder {
        private int catalogVersion;
        private int executionToken;
        private FragmentDescription fragmentDescription;
        private byte[] fragmentDescriptionByteArray;
        private long fragmentId;
        private HybridTimestamp operationTime;
        private Object[] parameters;
        private byte[] parametersByteArray;
        private UUID queryId;
        private String root;
        private String timeZoneId;
        private HybridTimestamp timestamp;
        private TxAttributes txAttributes;
        private byte[] txAttributesByteArray;

        private Builder() {
        }

        @Override
        public QueryStartRequestBuilder catalogVersion(int catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        @Override
        public QueryStartRequestBuilder executionToken(int executionToken) {
            this.executionToken = executionToken;
            return this;
        }

        @Override
        public QueryStartRequestBuilder fragmentDescription(FragmentDescription fragmentDescription) {
            Objects.requireNonNull(fragmentDescription, "fragmentDescription is not marked @Nullable");
            this.fragmentDescription = fragmentDescription;
            return this;
        }

        @Override
        public QueryStartRequestBuilder fragmentDescriptionByteArray(byte[] fragmentDescriptionByteArray) {
            this.fragmentDescriptionByteArray = fragmentDescriptionByteArray;
            return this;
        }

        @Override
        public QueryStartRequestBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public QueryStartRequestBuilder operationTime(HybridTimestamp operationTime) {
            Objects.requireNonNull(operationTime, "operationTime is not marked @Nullable");
            this.operationTime = operationTime;
            return this;
        }

        @Override
        public QueryStartRequestBuilder parameters(Object[] parameters) {
            Objects.requireNonNull(parameters, "parameters is not marked @Nullable");
            this.parameters = parameters;
            return this;
        }

        @Override
        public QueryStartRequestBuilder parametersByteArray(byte[] parametersByteArray) {
            this.parametersByteArray = parametersByteArray;
            return this;
        }

        @Override
        public QueryStartRequestBuilder queryId(UUID queryId) {
            Objects.requireNonNull(queryId, "queryId is not marked @Nullable");
            this.queryId = queryId;
            return this;
        }

        @Override
        public QueryStartRequestBuilder root(String root) {
            Objects.requireNonNull(root, "root is not marked @Nullable");
            this.root = root;
            return this;
        }

        @Override
        public QueryStartRequestBuilder timeZoneId(String timeZoneId) {
            Objects.requireNonNull(timeZoneId, "timeZoneId is not marked @Nullable");
            this.timeZoneId = timeZoneId;
            return this;
        }

        @Override
        public QueryStartRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public QueryStartRequestBuilder txAttributes(TxAttributes txAttributes) {
            Objects.requireNonNull(txAttributes, "txAttributes is not marked @Nullable");
            this.txAttributes = txAttributes;
            return this;
        }

        @Override
        public QueryStartRequestBuilder txAttributesByteArray(byte[] txAttributesByteArray) {
            this.txAttributesByteArray = txAttributesByteArray;
            return this;
        }

        @Override
        public int catalogVersion() {
            return this.catalogVersion;
        }

        @Override
        public int executionToken() {
            return this.executionToken;
        }

        @Override
        public FragmentDescription fragmentDescription() {
            return this.fragmentDescription;
        }

        @Override
        public byte[] fragmentDescriptionByteArray() {
            return this.fragmentDescriptionByteArray;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public HybridTimestamp operationTime() {
            return this.operationTime;
        }

        @Override
        public Object[] parameters() {
            return this.parameters;
        }

        @Override
        public byte[] parametersByteArray() {
            return this.parametersByteArray;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public String root() {
            return this.root;
        }

        @Override
        public String timeZoneId() {
            return this.timeZoneId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public TxAttributes txAttributes() {
            return this.txAttributes;
        }

        @Override
        public byte[] txAttributesByteArray() {
            return this.txAttributesByteArray;
        }

        @Override
        public QueryStartRequest build() {
            return new QueryStartRequestImpl(this.catalogVersion, this.executionToken, this.fragmentDescription, this.fragmentDescriptionByteArray, this.fragmentId, Objects.requireNonNull(this.operationTime, "operationTime is not marked @Nullable"), this.parameters, this.parametersByteArray, Objects.requireNonNull(this.queryId, "queryId is not marked @Nullable"), Objects.requireNonNull(this.root, "root is not marked @Nullable"), Objects.requireNonNull(this.timeZoneId, "timeZoneId is not marked @Nullable"), this.timestamp, this.txAttributes, this.txAttributesByteArray);
        }
    }
}

