/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.Storable;
import org.apache.ignite.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.StorageRebalanceException;
import org.apache.ignite.internal.storage.TxIdMismatchException;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.index.hash.PageMemoryHashIndexStorage;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.index.sorted.PageMemorySortedIndexStorage;
import org.apache.ignite.internal.storage.pagememory.mv.AbortWriteInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.mv.AddWriteCommittedInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.mv.AddWriteInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.mv.CommitWriteInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.mv.FindRowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.LatestVersionsCursor;
import org.apache.ignite.internal.storage.pagememory.mv.PageMemoryIndexes;
import org.apache.ignite.internal.storage.pagememory.mv.ReadRowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.RemoveWriteOnGcInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.ScanVersionsCursor;
import org.apache.ignite.internal.storage.pagememory.mv.TimestampCursor;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainKey;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite.internal.storage.pagememory.mv.gc.GcRowVersion;
import org.apache.ignite.internal.storage.util.LocalLocker;
import org.apache.ignite.internal.storage.util.LockByRowId;
import org.apache.ignite.internal.storage.util.StorageState;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.CursorUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPageMemoryMvPartitionStorage
implements MvPartitionStorage {
    static final Predicate<HybridTimestamp> ALWAYS_LOAD_VALUE = timestamp -> true;
    static final Predicate<HybridTimestamp> DONT_LOAD_VALUE = timestamp -> false;
    static final ThreadLocal<LocalLocker> THREAD_LOCAL_LOCKER = new ThreadLocal();
    protected final int partitionId;
    protected final AbstractPageMemoryTableStorage tableStorage;
    final PageMemoryIndexes indexes;
    final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);
    final LockByRowId lockByRowId = new LockByRowId();
    final GradualTaskExecutor destructionExecutor;
    volatile RenewablePartitionStorageState renewableState;
    private final DataPageReader rowVersionDataPageReader;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final RemoveWriteOnGcInvokeClosure.UpdateNextLinkHandler updateNextLinkHandler;
    private final CommitWriteInvokeClosure.UpdateTimestampHandler updateTimestampHandler;

    AbstractPageMemoryMvPartitionStorage(int partitionId, AbstractPageMemoryTableStorage tableStorage, RenewablePartitionStorageState renewableState, ExecutorService destructionExecutor) {
        this.partitionId = partitionId;
        this.tableStorage = tableStorage;
        this.renewableState = renewableState;
        this.destructionExecutor = this.createGradualTaskExecutor(destructionExecutor);
        this.indexes = new PageMemoryIndexes(this.destructionExecutor, arg_0 -> ((AbstractPageMemoryMvPartitionStorage)this).runConsistently(arg_0));
        PageMemory pageMemory = tableStorage.dataRegion().pageMemory();
        this.rowVersionDataPageReader = new DataPageReader(pageMemory, tableStorage.getTableId(), (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
        this.updateNextLinkHandler = new RemoveWriteOnGcInvokeClosure.UpdateNextLinkHandler();
        this.updateTimestampHandler = new CommitWriteInvokeClosure.UpdateTimestampHandler();
    }

    protected abstract GradualTaskExecutor createGradualTaskExecutor(ExecutorService var1);

    public void start() {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            RenewablePartitionStorageState localState = this.renewableState;
            try {
                this.indexes.performRecovery(localState.indexMetaTree(), localState.indexStorageFactory(), this.tableStorage.getIndexDescriptorSupplier());
            }
            catch (Exception e) {
                throw new StorageException("Failed to process SQL indexes during partition start: [{}]", (Throwable)e, new Object[]{this.createStorageInfo()});
            }
            return null;
        });
    }

    public int partitionId() {
        return this.partitionId;
    }

    public PageMemoryHashIndexStorage getOrCreateHashIndex(StorageHashIndexDescriptor indexDescriptor) {
        return this.busy(() -> this.indexes.getOrCreateHashIndex(indexDescriptor, this.renewableState.indexStorageFactory()));
    }

    public PageMemorySortedIndexStorage getOrCreateSortedIndex(StorageSortedIndexDescriptor indexDescriptor) {
        return this.busy(() -> this.indexes.getOrCreateSortedIndex(indexDescriptor, this.renewableState.indexStorageFactory()));
    }

    void updateRenewableState(VersionChainTree versionChainTree, FreeListImpl freeList, IndexMetaTree indexMetaTree, GcQueue gcQueue) {
        RenewablePartitionStorageState newState;
        this.renewableState = newState = new RenewablePartitionStorageState(this.tableStorage, this.partitionId, versionChainTree, freeList, indexMetaTree, gcQueue);
        this.indexes.updateDataStructures(newState.indexStorageFactory());
    }

    static boolean rowIsLocked(RowId rowId) {
        LocalLocker locker = THREAD_LOCAL_LOCKER.get();
        return locker != null && locker.isLocked(rowId);
    }

    public ReadResult read(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            if (rowId.partitionId() != this.partitionId) {
                throw new IllegalArgumentException(String.format("RowId partition [%d] is not equal to storage partition [%d].", rowId.partitionId(), this.partitionId));
            }
            return this.findVersionChain(rowId, versionChain -> {
                if (versionChain == null) {
                    return ReadResult.empty((RowId)rowId);
                }
                if (AbstractPageMemoryMvPartitionStorage.lookingForLatestVersion(timestamp)) {
                    return this.findLatestRowVersion((VersionChain)versionChain);
                }
                return this.findRowVersionByTimestamp((VersionChain)versionChain, timestamp);
            });
        });
    }

    private static boolean lookingForLatestVersion(HybridTimestamp timestamp) {
        return HybridTimestamp.MAX_VALUE.equals((Object)timestamp);
    }

    ReadResult findLatestRowVersion(VersionChain versionChain) {
        RowVersion rowVersion = this.readRowVersion(versionChain.headLink(), ALWAYS_LOAD_VALUE);
        if (versionChain.isUncommitted()) {
            assert (versionChain.transactionId() != null);
            HybridTimestamp newestCommitTs = null;
            if (versionChain.hasCommittedVersions()) {
                long newestCommitLink = versionChain.newestCommittedLink();
                newestCommitTs = this.readRowVersion(newestCommitLink, ALWAYS_LOAD_VALUE).timestamp();
            }
            return AbstractPageMemoryMvPartitionStorage.writeIntentToResult(versionChain, rowVersion, newestCommitTs);
        }
        return ReadResult.createFromCommitted((RowId)versionChain.rowId(), (BinaryRow)rowVersion.value(), (HybridTimestamp)rowVersion.timestamp());
    }

    RowVersion readRowVersion(long rowVersionLink, Predicate<HybridTimestamp> loadValue) {
        ReadRowVersion read = new ReadRowVersion(this.partitionId);
        try {
            this.rowVersionDataPageReader.traverse(rowVersionLink, (PageMemoryTraversal)read, loadValue);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Row version lookup failed: [link={}, {}]", (Throwable)e, new Object[]{rowVersionLink, this.createStorageInfo()});
        }
        return read.result();
    }

    @Nullable
    RowVersion findRowVersion(VersionChain versionChain, FindRowVersion.RowVersionFilter filter, boolean loadValueBytes) {
        assert (versionChain.hasHeadLink());
        FindRowVersion findRowVersion = new FindRowVersion(this.partitionId, loadValueBytes);
        try {
            this.rowVersionDataPageReader.traverse(versionChain.headLink(), (PageMemoryTraversal)findRowVersion, (Object)filter);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error when looking up row version in version chain: [rowId={}, headLink={}, {}]", (Throwable)e, new Object[]{versionChain.rowId(), versionChain.headLink(), this.createStorageInfo()});
        }
        return findRowVersion.getResult();
    }

    ReadResult findRowVersionByTimestamp(VersionChain versionChain, HybridTimestamp timestamp) {
        assert (timestamp != null);
        long headLink = versionChain.headLink();
        if (versionChain.isUncommitted() && !versionChain.hasCommittedVersions()) {
            RowVersion rowVersion = this.readRowVersion(headLink, ALWAYS_LOAD_VALUE);
            return AbstractPageMemoryMvPartitionStorage.writeIntentToResult(versionChain, rowVersion, null);
        }
        return this.walkVersionChain(versionChain, timestamp);
    }

    private ReadResult walkVersionChain(VersionChain chain, HybridTimestamp timestamp) {
        assert (chain.hasCommittedVersions());
        boolean hasWriteIntent = chain.isUncommitted();
        RowVersion firstCommit = hasWriteIntent ? this.readRowVersion(chain.nextLink(), rowTimestamp -> timestamp.compareTo(rowTimestamp) == 0) : this.readRowVersion(chain.headLink(), rowTimestamp -> timestamp.compareTo(rowTimestamp) >= 0);
        assert (firstCommit.isCommitted());
        assert (firstCommit.timestamp() != null);
        if (hasWriteIntent && timestamp.compareTo(firstCommit.timestamp()) > 0) {
            RowVersion rowVersion = this.readRowVersion(chain.headLink(), ALWAYS_LOAD_VALUE);
            return AbstractPageMemoryMvPartitionStorage.writeIntentToResult(chain, rowVersion, firstCommit.timestamp());
        }
        RowVersion curCommit = firstCommit;
        do {
            assert (curCommit.timestamp() != null);
            int compareResult = timestamp.compareTo(curCommit.timestamp());
            if (compareResult < 0) continue;
            BinaryRow row = curCommit.isTombstone() ? null : curCommit.value();
            return ReadResult.createFromCommitted((RowId)chain.rowId(), (BinaryRow)row, (HybridTimestamp)curCommit.timestamp());
        } while ((curCommit = !curCommit.hasNextLink() ? null : this.readRowVersion(curCommit.nextLink(), rowTimestamp -> timestamp.compareTo(rowTimestamp) >= 0)) != null);
        return ReadResult.empty((RowId)chain.rowId());
    }

    private static ReadResult writeIntentToResult(VersionChain chain, RowVersion rowVersion, @Nullable HybridTimestamp lastCommittedTimestamp) {
        assert (rowVersion.isUncommitted());
        UUID transactionId = chain.transactionId();
        int commitTableId = chain.commitTableId();
        int commitPartitionId = chain.commitPartitionId();
        return ReadResult.createFromWriteIntent((RowId)chain.rowId(), (BinaryRow)rowVersion.value(), (UUID)transactionId, (int)commitTableId, (int)commitPartitionId, (HybridTimestamp)lastCommittedTimestamp);
    }

    void insertRowVersion(RowVersion rowVersion) {
        try {
            this.renewableState.freeList().insertDataRow((Storable)rowVersion);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot store a row version: [row={}, {}]", (Throwable)e, new Object[]{rowVersion, this.createStorageInfo()});
        }
    }

    @Nullable
    public BinaryRow addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableId, int commitPartitionId) throws TxIdMismatchException, StorageException {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)this.state.get(), this::createStorageInfo);
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId));
            try {
                AddWriteInvokeClosure addWrite = new AddWriteInvokeClosure(rowId, row, txId, commitTableId, commitPartitionId, this);
                this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, addWrite);
                addWrite.afterCompletion();
                return addWrite.getPreviousUncommittedRowVersion();
            }
            catch (IgniteInternalCheckedException e) {
                StorageUtils.throwStorageExceptionIfItCause((IgniteInternalCheckedException)e);
                if (e.getCause() instanceof TxIdMismatchException) {
                    throw (TxIdMismatchException)e.getCause();
                }
                throw new StorageException("Error while executing addWrite: [rowId={}, {}]", (Throwable)e, new Object[]{rowId, this.createStorageInfo()});
            }
        });
    }

    @Nullable
    public BinaryRow abortWrite(RowId rowId) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId));
            try {
                AbortWriteInvokeClosure abortWrite = new AbortWriteInvokeClosure(rowId, this);
                this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, abortWrite);
                abortWrite.afterCompletion();
                return abortWrite.getPreviousUncommittedRowVersion();
            }
            catch (IgniteInternalCheckedException e) {
                StorageUtils.throwStorageExceptionIfItCause((IgniteInternalCheckedException)e);
                throw new StorageException("Error while executing abortWrite: [rowId={}, {}]", (Throwable)e, new Object[]{rowId, this.createStorageInfo()});
            }
        });
    }

    public void commitWrite(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)this.state.get(), this::createStorageInfo);
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId));
            try {
                CommitWriteInvokeClosure commitWrite = new CommitWriteInvokeClosure(rowId, timestamp, this.updateTimestampHandler, this);
                this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, commitWrite);
                commitWrite.afterCompletion();
                return null;
            }
            catch (IgniteInternalCheckedException e) {
                StorageUtils.throwStorageExceptionIfItCause((IgniteInternalCheckedException)e);
                throw new StorageException("Error while executing commitWrite: [rowId={}, {}]", (Throwable)e, new Object[]{rowId, this.createStorageInfo()});
            }
        });
    }

    void removeRowVersion(RowVersion rowVersion) {
        try {
            this.renewableState.freeList().removeDataRowByLink(rowVersion.link());
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot remove row version: [row={}, {}]", (Throwable)e, new Object[]{rowVersion, this.createStorageInfo()});
        }
    }

    public void addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)this.state.get(), this::createStorageInfo);
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId));
            try {
                AddWriteCommittedInvokeClosure addWriteCommitted = new AddWriteCommittedInvokeClosure(rowId, row, commitTimestamp, this);
                this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, addWriteCommitted);
                addWriteCommitted.afterCompletion();
                return null;
            }
            catch (IgniteInternalCheckedException e) {
                StorageUtils.throwStorageExceptionIfItCause((IgniteInternalCheckedException)e);
                throw new StorageException("Error while executing addWriteCommitted: [rowId={}, {}]", (Throwable)e, new Object[]{rowId, this.createStorageInfo()});
            }
        });
    }

    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId));
            return this.findVersionChain(rowId, versionChain -> {
                if (versionChain == null) {
                    return CursorUtils.emptyCursor();
                }
                return new ScanVersionsCursor((VersionChain)versionChain, this);
            });
        });
    }

    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            if (AbstractPageMemoryMvPartitionStorage.lookingForLatestVersion(timestamp)) {
                return new LatestVersionsCursor(this);
            }
            return new TimestampCursor(this, timestamp);
        });
    }

    @Nullable
    public RowId closestRowId(RowId lowerBound) throws StorageException {
        return this.busy(() -> {
            RowId rowId;
            block8: {
                this.throwExceptionIfStorageNotInRunnableState();
                Cursor cursor = this.renewableState.versionChainTree().find(new VersionChainKey(lowerBound), null);
                try {
                    RowId rowId2 = rowId = cursor.hasNext() ? ((VersionChain)cursor.next()).rowId() : null;
                    if (cursor == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (cursor != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new StorageException("Error occurred while trying to read a row id", (Throwable)e);
                    }
                }
                cursor.close();
            }
            return rowId;
        });
    }

    public void close() {
        if (!this.transitionToTerminalState(StorageState.CLOSED)) {
            return;
        }
        this.busyLock.block();
        this.closeResources();
    }

    private boolean transitionToTerminalState(StorageState targetState) {
        return StorageUtils.transitionToTerminalState((StorageState)targetState, this.state);
    }

    public void closeResources() {
        try {
            IgniteUtils.closeAll(this.getResourcesToClose());
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    protected List<AutoCloseable> getResourcesToClose() {
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
        RenewablePartitionStorageState localState = this.renewableState;
        resources.add(() -> ((GradualTaskExecutor)this.destructionExecutor).close());
        resources.add(() -> ((VersionChainTree)localState.versionChainTree()).close());
        resources.add(() -> ((IndexMetaTree)localState.indexMetaTree()).close());
        resources.add(() -> ((GcQueue)localState.gcQueue()).close());
        resources.addAll(this.indexes.getResourcesToClose());
        return resources;
    }

    public boolean transitionToDestroyedState() {
        if (!this.transitionToTerminalState(StorageState.DESTROYED)) {
            return false;
        }
        this.indexes.transitionToDestroyedState();
        this.busyLock.block();
        return true;
    }

    <V> V busy(Supplier<V> supplier) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnStorageState((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    void busySafe(Runnable fn) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            fn.run();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public String createStorageInfo() {
        return IgniteStringFormatter.format((String)"tableId={}, partitionId={}", (Object[])new Object[]{this.tableStorage.getTableId(), this.partitionId});
    }

    public void startRebalance() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.REBALANCE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAll(this.getResourcesToCloseOnCleanup());
            this.indexes.startRebalance();
        }
        catch (Exception e) {
            throw new StorageRebalanceException(IgniteStringFormatter.format((String)"Error on start of rebalancing: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void completeRebalance() {
        if (!this.state.compareAndSet(StorageState.REBALANCE, StorageState.RUNNABLE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        this.indexes.completeRebalance();
    }

    public abstract void lastAppliedOnRebalance(long var1, long var3) throws StorageException;

    abstract List<AutoCloseable> getResourcesToCloseOnCleanup();

    public abstract void committedGroupConfigurationOnRebalance(byte[] var1);

    public abstract void updateLeaseOnRebalance(long var1, UUID var3, String var4);

    public void startCleanup() throws Exception {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.CLEANUP)) {
            StorageUtils.throwExceptionDependingOnStorageState((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAll(this.getResourcesToCloseOnCleanup());
            this.indexes.startCleanup();
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void finishCleanup() {
        if (this.state.compareAndSet(StorageState.CLEANUP, StorageState.RUNNABLE)) {
            this.indexes.finishCleanup();
        }
    }

    void throwExceptionIfStorageNotInRunnableState() {
        StorageUtils.throwExceptionIfStorageNotInRunnableState((StorageState)this.state.get(), this::createStorageInfo);
    }

    @Nullable
    <T> T findVersionChain(RowId rowId, final Function<VersionChain, T> mapper) {
        try {
            return (T)this.renewableState.versionChainTree().findOne(new VersionChainKey(rowId), new BplusTree.TreeRowMapClosure<VersionChainKey, VersionChain, T>(){

                public T map(VersionChain treeRow) {
                    return mapper.apply(treeRow);
                }
            }, null);
        }
        catch (IgniteInternalCheckedException e) {
            StorageUtils.throwStorageExceptionIfItCause((IgniteInternalCheckedException)e);
            throw new StorageException("Row version lookup failed: [rowId={}, {}]", (Throwable)e, new Object[]{rowId, this.createStorageInfo()});
        }
    }

    @Nullable
    public GcEntry peek(HybridTimestamp lowWatermark) {
        assert (THREAD_LOCAL_LOCKER.get() != null);
        this.throwExceptionIfStorageNotInRunnableState();
        GcRowVersion head = this.renewableState.gcQueue().getFirst();
        if (head == null) {
            return null;
        }
        HybridTimestamp rowTimestamp = head.getTimestamp();
        if (rowTimestamp.compareTo(lowWatermark) > 0) {
            return null;
        }
        return head;
    }

    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        assert (THREAD_LOCAL_LOCKER.get() != null);
        assert (THREAD_LOCAL_LOCKER.get().isLocked(entry.getRowId()));
        this.throwExceptionIfStorageNotInRunnableState();
        assert (entry instanceof GcRowVersion) : entry;
        GcRowVersion gcRowVersion = (GcRowVersion)entry;
        RowId rowId = entry.getRowId();
        HybridTimestamp rowTimestamp = gcRowVersion.getTimestamp();
        if (!this.renewableState.gcQueue().remove(rowId, rowTimestamp, gcRowVersion.getLink())) {
            return null;
        }
        RowVersion removedRowVersion = this.removeWriteOnGc(rowId, rowTimestamp, gcRowVersion.getLink());
        return removedRowVersion.value();
    }

    private RowVersion removeWriteOnGc(RowId rowId, HybridTimestamp rowTimestamp, long rowLink) {
        RemoveWriteOnGcInvokeClosure removeWriteOnGc = new RemoveWriteOnGcInvokeClosure(rowId, rowTimestamp, rowLink, this.updateNextLinkHandler, this);
        try {
            this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, removeWriteOnGc);
        }
        catch (IgniteInternalCheckedException e) {
            StorageUtils.throwStorageExceptionIfItCause((IgniteInternalCheckedException)e);
            throw new StorageException("Error removing row version from version chain on garbage collection: [rowId={}, rowTimestamp={}, {}]", (Throwable)e, new Object[]{rowId, rowTimestamp, this.createStorageInfo()});
        }
        removeWriteOnGc.afterCompletion();
        return removeWriteOnGc.getResult();
    }

    @Nullable
    public IndexStorage getIndex(int indexId) {
        return this.busy(() -> this.indexes.getIndex(indexId));
    }

    public CompletableFuture<Void> destroyIndex(int indexId) {
        return this.busy(() -> this.indexes.destroyIndex(indexId, this.renewableState.indexMetaTree()));
    }

    public abstract void incrementEstimatedSize();

    public abstract void decrementEstimatedSize();
}

