/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.time.ZoneId;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.jdbc.JdbcQueryExecuteResponse;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.TcpIgniteClient;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.JdbcQueryEventHandler;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcBatchPreparedStmntRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcConnectResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcFinishTxResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcMetaPrimaryKeysResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcMetaSchemasRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcMetaSchemasResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcMetaTablesRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcMetaTablesResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCancelResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcQueryExecuteRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class JdbcClientQueryEventHandler
implements JdbcQueryEventHandler {
    private final TcpIgniteClient client;

    JdbcClientQueryEventHandler(TcpIgniteClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<JdbcConnectResult> connect(ZoneId timeZoneId, @Nullable String username) {
        assert (username == null) : "Username should be passed via client handshake";
        return this.client.sendRequestAsync(54, w -> w.out().packString(timeZoneId.getId()), r -> {
            JdbcConnectResult res = new JdbcConnectResult();
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<Response> queryAsync(long connectionId, JdbcQueryExecuteRequest req) {
        return this.client.sendRequestAsync(34, w -> {
            w.out().packLong(connectionId);
            req.writeBinary(w.out());
        }, r -> {
            JdbcQueryExecuteResponse res = new JdbcQueryExecuteResponse(r.clientChannel());
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcBatchExecuteResult> batchAsync(long connectionId, JdbcBatchExecuteRequest req) {
        return this.client.sendRequestAsync(36, w -> {
            w.out().packLong(connectionId);
            req.writeBinary(w.out());
        }, r -> {
            JdbcBatchExecuteResult res = new JdbcBatchExecuteResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcBatchExecuteResult> batchPrepStatementAsync(long connectionId, JdbcBatchPreparedStmntRequest req) {
        return this.client.sendRequestAsync(46, w -> {
            w.out().packLong(connectionId);
            req.writeBinary(w.out());
        }, r -> {
            JdbcBatchExecuteResult res = new JdbcBatchExecuteResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcMetaTablesResult> tablesMetaAsync(JdbcMetaTablesRequest req) {
        return this.client.sendRequestAsync(38, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaTablesResult res = new JdbcMetaTablesResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcMetaColumnsResult> columnsMetaAsync(JdbcMetaColumnsRequest req) {
        return this.client.sendRequestAsync(39, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaColumnsResult res = new JdbcMetaColumnsResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcMetaSchemasResult> schemasMetaAsync(JdbcMetaSchemasRequest req) {
        return this.client.sendRequestAsync(40, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaSchemasResult res = new JdbcMetaSchemasResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcMetaPrimaryKeysResult> primaryKeysMetaAsync(JdbcMetaPrimaryKeysRequest req) {
        return this.client.sendRequestAsync(41, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaPrimaryKeysResult res = new JdbcMetaPrimaryKeysResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcFinishTxResult> finishTxAsync(long connectionId, boolean commit) {
        return this.client.sendRequestAsync(55, w -> {
            w.out().packLong(connectionId);
            w.out().packBoolean(commit);
        }, r -> {
            JdbcFinishTxResult res = new JdbcFinishTxResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcQueryCancelResult> cancelAsync(long connectionId, long correlationToken) {
        return this.client.sendRequestAsync(68, w -> {
            w.out().packLong(connectionId);
            w.out().packLong(correlationToken);
        }, r -> {
            JdbcQueryCancelResult res = new JdbcQueryCancelResult();
            res.readBinary(r.in());
            return res;
        });
    }
}

