/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.metrics.ExporterMetrics;
import io.opentelemetry.exporter.internal.metrics.LegacyExporterMetrics;
import io.opentelemetry.exporter.internal.metrics.NoopExporterMetrics;
import io.opentelemetry.exporter.internal.metrics.SemConvExporterMetrics;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.internal.ComponentId;
import io.opentelemetry.sdk.internal.SemConvAttributes;
import io.opentelemetry.sdk.internal.Signal;
import io.opentelemetry.sdk.internal.StandardComponentId;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ExporterInstrumentation {
    private final ExporterMetrics implementation;

    public ExporterInstrumentation(InternalTelemetryVersion schema, Supplier<MeterProvider> meterProviderSupplier, StandardComponentId componentId, String endpoint) {
        Signal signal = componentId.getStandardType().signal();
        switch (schema) {
            case LEGACY: {
                this.implementation = LegacyExporterMetrics.isSupportedType(componentId.getStandardType()) ? new LegacyExporterMetrics(meterProviderSupplier, componentId.getStandardType()) : NoopExporterMetrics.INSTANCE;
                break;
            }
            case LATEST: {
                this.implementation = signal == Signal.PROFILE ? NoopExporterMetrics.INSTANCE : new SemConvExporterMetrics(meterProviderSupplier, signal, (ComponentId)componentId, ExporterInstrumentation.extractServerAttributes(endpoint));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled case: " + schema);
            }
        }
    }

    static Attributes extractServerAttributes(String httpEndpoint) {
        try {
            int port;
            URI parsed = new URI(httpEndpoint);
            AttributesBuilder builder = Attributes.builder();
            String host = parsed.getHost();
            if (host != null) {
                builder.put(SemConvAttributes.SERVER_ADDRESS, (Object)host);
            }
            if ((port = parsed.getPort()) == -1) {
                String scheme = parsed.getScheme();
                if ("https".equals(scheme)) {
                    port = 443;
                } else if ("http".equals(scheme)) {
                    port = 80;
                }
            }
            if (port != -1) {
                builder.put(SemConvAttributes.SERVER_PORT, port);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            return Attributes.empty();
        }
    }

    public Recording startRecordingExport(int itemCount) {
        return new Recording(this.implementation.startRecordingExport(itemCount));
    }

    public static class Recording {
        private final ExporterMetrics.Recording delegate;
        @Nullable
        private Long httpStatusCode;
        @Nullable
        private Long grpcStatusCode;

        private Recording(ExporterMetrics.Recording delegate) {
            this.delegate = delegate;
        }

        public void setHttpStatusCode(long httpStatusCode) {
            if (this.grpcStatusCode != null) {
                throw new IllegalStateException("gRPC status code already set, can only set either gRPC or HTTP");
            }
            this.httpStatusCode = httpStatusCode;
        }

        public void setGrpcStatusCode(long grpcStatusCode) {
            if (this.httpStatusCode != null) {
                throw new IllegalStateException("HTTP status code already set, can only set either gRPC or HTTP");
            }
            this.grpcStatusCode = grpcStatusCode;
        }

        public void finishSuccessful() {
            this.delegate.finishSuccessful(this.buildRequestAttributes());
        }

        public void finishFailed(Throwable failureCause) {
            this.finishFailed(failureCause.getClass().getName());
        }

        public void finishFailed(String errorType) {
            this.delegate.finishFailed(errorType, this.buildRequestAttributes());
        }

        private Attributes buildRequestAttributes() {
            if (this.httpStatusCode != null) {
                return Attributes.of((AttributeKey)SemConvAttributes.HTTP_RESPONSE_STATUS_CODE, (Object)this.httpStatusCode);
            }
            if (this.grpcStatusCode != null) {
                return Attributes.of((AttributeKey)SemConvAttributes.RPC_GRPC_STATUS_CODE, (Object)this.grpcStatusCode);
            }
            return Attributes.empty();
        }
    }
}

