/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class ProcessUtil {
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean");
    private static final List<String> POSSIBLE_METHODS = Arrays.asList("getProcessCpuLoad", "getSystemCpuLoad", "getCpuLoad");
    private static final IProcessCpuLoad CPU_LOAD;

    public static double cpuLoad() {
        return CPU_LOAD.get();
    }

    public static String processId() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    private static Method findMethod(Class<?> clazz) {
        for (String methodName : POSSIBLE_METHODS) {
            try {
                return clazz.getMethod(methodName, new Class[0]);
            }
            catch (ClassCastException | NoSuchMethodException | SecurityException exception) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
        Method method = null;
        for (String className : OPERATING_SYSTEM_BEAN_CLASS_NAMES) {
            try {
                Class<?> osBeanClass = Class.forName(className);
                osBeanClass.cast(operatingSystemBean);
                method = ProcessUtil.findMethod(osBeanClass);
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (method != null) {
            IProcessCpuLoad finalMethod = null;
            try {
                double load = (Double)method.invoke((Object)operatingSystemBean, new Object[0]);
                finalMethod = new ProcessCpuLoad(operatingSystemBean, method);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                finalMethod = () -> Double.NaN;
            }
            finally {
                CPU_LOAD = finalMethod;
            }
        } else {
            CPU_LOAD = () -> Double.NaN;
        }
    }

    private static interface IProcessCpuLoad {
        public double get();
    }

    private static class ProcessCpuLoad
    implements IProcessCpuLoad {
        private final OperatingSystemMXBean operatingSystemBean;
        private final Method cpuUsageMethod;

        private ProcessCpuLoad(OperatingSystemMXBean operatingSystemBean, Method cpuUsageMethod) {
            this.operatingSystemBean = operatingSystemBean;
            this.cpuUsageMethod = cpuUsageMethod;
        }

        @Override
        public double get() {
            try {
                double load = (Double)this.cpuUsageMethod.invoke((Object)this.operatingSystemBean, new Object[0]);
                return load > 1.0 ? load / 100.0 : load;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return Double.NaN;
            }
        }
    }
}

