/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.server;

import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.bifromq.baserpc.RPCContext;
import org.apache.bifromq.baserpc.metrics.IRPCMeter;
import org.apache.bifromq.baserpc.metrics.RPCMetric;

public final class UnaryResponse {
    public static <RespT> void response(Function<String, CompletionStage<RespT>> reqHandler, StreamObserver<RespT> observer) {
        UnaryResponse.response((String tenantId, Map<String, String> metadata) -> (CompletionStage)reqHandler.apply((String)tenantId), observer);
    }

    public static <RespT> void response(BiFunction<String, Map<String, String>, CompletionStage<RespT>> reqHandler, StreamObserver<RespT> observer) {
        IRPCMeter.IRPCMethodMeter meter = (IRPCMeter.IRPCMethodMeter)RPCContext.METER_KEY_CTX_KEY.get();
        String tenantId = (String)RPCContext.TENANT_ID_CTX_KEY.get();
        Map metadata = (Map)RPCContext.CUSTOM_METADATA_CTX_KEY.get();
        Timer.Sample sample = Timer.start();
        meter.recordCount(RPCMetric.UnaryReqReceivedCount);
        reqHandler.apply(tenantId, metadata).whenComplete((v, e) -> {
            sample.stop(meter.timer(RPCMetric.UnaryReqProcessLatency));
            if (e != null) {
                observer.onError(e);
                meter.recordCount(RPCMetric.UnaryReqFailCount);
            } else {
                observer.onNext(v);
                observer.onCompleted();
                meter.recordCount(RPCMetric.UnaryReqFulfillCount);
            }
        });
    }
}

