/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.client.IClientChannel;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.baserpc.client.ManagedBiDiStream;
import org.apache.bifromq.baserpc.client.exception.RequestRejectedException;
import org.apache.bifromq.baserpc.metrics.IRPCMeter;
import org.apache.bifromq.baserpc.metrics.RPCMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManagedMessageStream<MsgT, AckT>
extends ManagedBiDiStream<AckT, MsgT>
implements IRPCClient.IMessageStream<MsgT, AckT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagedMessageStream.class);
    private final ConcurrentLinkedQueue<AckT> ackSendingBuffers = new ConcurrentLinkedQueue();
    private final PublishSubject<MsgT> msgSubject = PublishSubject.create();
    private final PublishSubject<Long> retargetSubject = PublishSubject.create();
    private final IRPCMeter.IRPCMethodMeter meter;
    private final AtomicBoolean sending = new AtomicBoolean(false);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    ManagedMessageStream(String tenantId, String wchKey, String targetServerId, Supplier<Map<String, String>> metadataSupplier, IClientChannel channelHolder, CallOptions callOptions, MethodDescriptor<AckT, MsgT> methodDescriptor, BluePrint bluePrint, IRPCMeter.IRPCMethodMeter meter) {
        super(tenantId, wchKey, targetServerId, bluePrint.semantic(methodDescriptor.getFullMethodName()), metadataSupplier, channelHolder.channel(), callOptions, bluePrint.methodDesc(methodDescriptor.getFullMethodName()));
        this.meter = meter;
        this.start(channelHolder.serverSelectorObservable());
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void ack(AckT ack) {
        if (this.isClosed.get()) {
            throw new RequestRejectedException("Stream has closed");
        }
        switch (this.state()) {
            case Init: 
            case Normal: 
            case PendingRetarget: 
            case Retargeting: {
                log.trace("MsgStream@{} enqueue ack: {}", (Object)this.hashCode(), ack);
                this.ackSendingBuffers.offer(ack);
                this.sendUntilStreamNotReadyOrNoTask();
                this.meter.recordCount(RPCMetric.StreamAckAcceptCount);
                break;
            }
            case StreamDisconnect: 
            case NoServerAvailable: {
                log.trace("MsgStream@{} drop ack due to no server available: {}", (Object)this.hashCode(), ack);
                this.meter.recordCount(RPCMetric.StreamAckDropCount);
                break;
            }
        }
    }

    @Override
    public void onMessage(Consumer<MsgT> consumer) {
        this.msgSubject.subscribe(consumer::accept);
    }

    @Override
    public void onRetarget(Consumer<Long> consumer) {
        this.retargetSubject.subscribe(consumer::accept);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            super.close();
            this.meter.recordCount(RPCMetric.StreamCompleteCount);
            this.ackSendingBuffers.clear();
            this.msgSubject.onComplete();
            this.retargetSubject.onComplete();
        }
    }

    @Override
    boolean prepareRetarget() {
        return true;
    }

    @Override
    boolean canStartRetarget() {
        return true;
    }

    @Override
    void onStreamCreated() {
        this.meter.recordCount(RPCMetric.StreamCreateCount);
        this.retargetSubject.onNext((Object)System.nanoTime());
    }

    @Override
    void onStreamReady() {
        this.sendUntilStreamNotReadyOrNoTask();
    }

    @Override
    void onStreamError(Throwable e) {
        this.meter.recordCount(RPCMetric.StreamErrorCount);
        this.ackSendingBuffers.clear();
    }

    @Override
    void onNoServerAvailable() {
    }

    @Override
    void onServiceUnavailable() {
    }

    @Override
    void onReceive(MsgT out) {
        this.msgSubject.onNext(out);
        this.meter.recordCount(RPCMetric.StreamMsgReceiveCount);
    }

    private void sendUntilStreamNotReadyOrNoTask() {
        if (this.sending.compareAndSet(false, true)) {
            while (this.isReady() && !this.ackSendingBuffers.isEmpty()) {
                AckT ack = this.ackSendingBuffers.poll();
                this.send(ack);
                this.meter.recordCount(RPCMetric.StreamAckSendCount);
            }
            this.sending.set(false);
            if (this.isReady() && !this.ackSendingBuffers.isEmpty()) {
                this.sendUntilStreamNotReadyOrNoTask();
            }
        }
    }
}

