/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

final class AdaptiveWriteBudget {
    private static final long TARGET_LATENCY_MS = 50L;
    private static final double EMA_ALPHA = 0.3;
    private static final double FAST_THRESHOLD = 0.8;
    private static final double SLOW_THRESHOLD = 1.5;
    private static final double MULTIPLICATIVE_DECREASE = 0.5;
    private static final double ADDITIVE_INCREASE_RATIO = 0.1;
    private static final int FAST_SUCCESS_THRESHOLD = 3;
    private static final long INITIAL_ENTRY_BUDGET = 1024L;
    private static final long INITIAL_BYTE_BUDGET = 0x400000L;
    private static final long MAX_ENTRY_BUDGET = 128000L;
    private static final long MAX_BYTE_BUDGET = 0x10000000L;
    private static final long MIN_ENTRY_BUDGET = 1L;
    private static final long MIN_BYTE_BUDGET = 1L;
    private double entryBudgetEstimate = 1024.0;
    private double byteBudgetEstimate = 4194304.0;
    private double emaEntryRate = -1.0;
    private double emaByteRate = -1.0;
    private int consecutiveFastRounds = 0;

    AdaptiveWriteBudget() {
    }

    boolean shouldFlush(long entries, long bytes) {
        return entries >= this.currentEntryLimit() || bytes >= this.currentByteLimit();
    }

    void recordFlush(long entries, long bytes, long latencyMillis) {
        if (entries <= 0L && bytes <= 0L || latencyMillis <= 0L) {
            return;
        }
        double entryRate = entries > 0L ? (double)entries / (double)latencyMillis : 0.0;
        double byteRate = bytes > 0L ? (double)bytes / (double)latencyMillis : 0.0;
        this.emaEntryRate = this.ema(this.emaEntryRate, entryRate);
        this.emaByteRate = this.ema(this.emaByteRate, byteRate);
        double targetEntryBudget = this.clampEntryBudget(this.emaEntryRate * 50.0);
        double targetByteBudget = this.clampByteBudget(this.emaByteRate * 50.0);
        this.entryBudgetEstimate = this.clampEntryBudget(this.ema(this.entryBudgetEstimate, targetEntryBudget));
        this.byteBudgetEstimate = this.clampByteBudget(this.ema(this.byteBudgetEstimate, targetByteBudget));
        if ((double)latencyMillis > 75.0) {
            this.entryBudgetEstimate = this.clampEntryBudget(this.entryBudgetEstimate * 0.5);
            this.byteBudgetEstimate = this.clampByteBudget(this.byteBudgetEstimate * 0.5);
            this.consecutiveFastRounds = 0;
            return;
        }
        if ((double)latencyMillis < 40.0) {
            ++this.consecutiveFastRounds;
            if (this.consecutiveFastRounds >= 3) {
                this.entryBudgetEstimate = this.clampEntryBudget(this.entryBudgetEstimate + Math.max(1.0, this.entryBudgetEstimate * 0.1));
                this.byteBudgetEstimate = this.clampByteBudget(this.byteBudgetEstimate + Math.max(1.0, this.byteBudgetEstimate * 0.1));
                this.consecutiveFastRounds = 0;
            }
        } else {
            this.consecutiveFastRounds = 0;
        }
    }

    long currentEntryLimit() {
        double budget = this.clampEntryBudget(this.entryBudgetEstimate);
        return Math.max(1L, (long)Math.ceil(budget));
    }

    long currentByteLimit() {
        double budget = this.clampByteBudget(this.byteBudgetEstimate);
        return Math.max(1L, (long)Math.ceil(budget));
    }

    private double clampEntryBudget(double value) {
        return this.clampDouble(value, 1.0, 128000.0);
    }

    private double clampByteBudget(double value) {
        return this.clampDouble(value, 1.0, 2.68435456E8);
    }

    private double clampDouble(double value, double min, double max) {
        return Math.min(Math.max(min, value), max);
    }

    private double ema(double current, double sample) {
        if (current < 0.0) {
            return sample;
        }
        return current + 0.3 * (sample - current);
    }
}

