/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.client;

import java.lang.ref.Cleaner;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.sessiondict.rpc.proto.Quit;
import org.apache.bifromq.sessiondict.rpc.proto.Session;
import org.apache.bifromq.sessiondict.rpc.proto.SessionDictServiceGrpc;
import org.apache.bifromq.type.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionRegister.class);
    private static final Cleaner CLEANER = Cleaner.create();
    private final IRPCClient.IMessageStream<Quit, Session> messageStream;
    private final Map<ClientInfo, Consumer<Quit>> sessions = new ConcurrentHashMap<ClientInfo, Consumer<Quit>>();
    private final Cleaner.Cleanable cleanable;

    SessionRegister(String tenantId, String registerKey, IRPCClient rpcClient) {
        this.messageStream = rpcClient.createMessageStream(tenantId, null, registerKey, Collections.emptyMap(), SessionDictServiceGrpc.getDictMethod());
        this.cleanable = CLEANER.register(this, new PipelineCloseAction(this.messageStream));
        this.messageStream.onMessage((Consumer)new QuitListener(this.sessions));
        this.messageStream.onRetarget((Consumer)new RetargetListener(this.sessions, this.messageStream));
    }

    public void sendRegInfo(ClientInfo owner, boolean keep) {
        this.messageStream.ack((Object)Session.newBuilder().setReqId(System.nanoTime()).setOwner(owner).setKeep(keep).build());
    }

    public void reg(ClientInfo owner, Consumer<Quit> kickConsumer) {
        this.sessions.put(owner, kickConsumer);
    }

    public void unreg(ClientInfo owner) {
        this.sessions.remove(owner);
    }

    public void close() {
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
    }

    private record PipelineCloseAction(IRPCClient.IMessageStream<Quit, Session> messageStream) implements Runnable
    {
        @Override
        public void run() {
            this.messageStream.close();
        }
    }

    private record QuitListener(Map<ClientInfo, Consumer<Quit>> sessions) implements Consumer<Quit>
    {
        @Override
        public void accept(Quit quit) {
            this.sessions.computeIfPresent(quit.getOwner(), (k, v) -> {
                v.accept(quit);
                return v;
            });
        }
    }

    private record RetargetListener(Map<ClientInfo, Consumer<Quit>> sessions, IRPCClient.IMessageStream<Quit, Session> messageStream) implements Consumer<Long>
    {
        @Override
        public void accept(Long ts) {
            for (ClientInfo owner : this.sessions.keySet()) {
                this.messageStream.ack((Object)Session.newBuilder().setReqId(System.nanoTime()).setOwner(owner).setKeep(true).build());
            }
        }
    }
}

