/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.client.scheduler;

import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.sessiondict.client.type.OnlineCheckRequest;
import org.apache.bifromq.sessiondict.client.type.OnlineCheckResult;
import org.apache.bifromq.sessiondict.rpc.proto.ExistReply;
import org.apache.bifromq.sessiondict.rpc.proto.ExistRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchSessionExistCall
implements IBatchCall<OnlineCheckRequest, OnlineCheckResult, String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchSessionExistCall.class);
    private final IRPCClient.IRequestPipeline<ExistRequest, ExistReply> ppln;
    private LinkedList<ICallTask<OnlineCheckRequest, OnlineCheckResult, String>> batchedTasks = new LinkedList();

    public BatchSessionExistCall(IRPCClient.IRequestPipeline<ExistRequest, ExistReply> ppln) {
        this.ppln = ppln;
    }

    public void add(ICallTask<OnlineCheckRequest, OnlineCheckResult, String> task) {
        this.batchedTasks.add(task);
    }

    public void reset(boolean abort) {
        if (abort) {
            this.batchedTasks = new LinkedList();
        }
    }

    public CompletableFuture<Void> execute() {
        return this.execute(this.batchedTasks);
    }

    private CompletableFuture<Void> execute(LinkedList<ICallTask<OnlineCheckRequest, OnlineCheckResult, String>> batchedTasks) {
        ExistRequest.Builder reqBuilder = ExistRequest.newBuilder().setReqId(System.nanoTime());
        batchedTasks.forEach(task -> reqBuilder.addClient(ExistRequest.Client.newBuilder().setUserId(((OnlineCheckRequest)task.call()).userId()).setClientId(((OnlineCheckRequest)task.call()).clientId()).build()));
        return this.ppln.invoke((Object)reqBuilder.build()).handle((reply, e) -> {
            if (e != null) {
                ICallTask task;
                log.debug("Session exist call failed", e);
                while ((task = (ICallTask)batchedTasks.poll()) != null) {
                    task.resultPromise().complete(OnlineCheckResult.ERROR);
                }
            } else {
                switch (reply.getCode()) {
                    case OK: {
                        ICallTask task;
                        assert (reply.getExistCount() == batchedTasks.size());
                        int i = 0;
                        while ((task = (ICallTask)batchedTasks.poll()) != null) {
                            task.resultPromise().complete(reply.getExist(i++) ? OnlineCheckResult.EXISTS : OnlineCheckResult.NOT_EXISTS);
                        }
                        break;
                    }
                    default: {
                        ICallTask task;
                        while ((task = (ICallTask)batchedTasks.poll()) != null) {
                            task.resultPromise().complete(OnlineCheckResult.ERROR);
                        }
                        break;
                    }
                }
            }
            return null;
        });
    }
}

