/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;

class TenantStats {
    private final AtomicLong topicCount = new AtomicLong();
    private final String tenantId;
    private final String[] tags;
    private boolean isLeader;

    TenantStats(String tenantId, Supplier<Number> usedSpaceGetter, String ... tags) {
        this.tenantId = tenantId;
        this.tags = tags;
        ITenantMeter.gauging((String)tenantId, (TenantMetric)TenantMetric.MqttRetainSpaceGauge, usedSpaceGetter, (String[])tags);
    }

    public long incrementTopicCount(int delta) {
        return this.topicCount.addAndGet(delta);
    }

    void toggleMetering(boolean isLeader) {
        if (!this.isLeader && isLeader) {
            ITenantMeter.gauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRetainNumGauge, this.topicCount::get, (String[])this.tags);
            this.isLeader = true;
        } else if (this.isLeader && !isLeader) {
            ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRetainNumGauge, (String[])this.tags);
            this.isLeader = false;
        }
    }

    void destroy() {
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRetainSpaceGauge, (String[])this.tags);
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRetainNumGauge, (String[])this.tags);
    }
}

