/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecrdt.core.api.CRDTURI;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDTInflater;
import org.apache.bifromq.basecrdt.core.internal.AWORSetInflater;
import org.apache.bifromq.basecrdt.core.internal.CCounterInflater;
import org.apache.bifromq.basecrdt.core.internal.DWFlagInflater;
import org.apache.bifromq.basecrdt.core.internal.EWFlagInflater;
import org.apache.bifromq.basecrdt.core.internal.InMemReplicaStateLattice;
import org.apache.bifromq.basecrdt.core.internal.MVRegInflater;
import org.apache.bifromq.basecrdt.core.internal.ORMapInflater;
import org.apache.bifromq.basecrdt.core.internal.RWORSetInflater;
import org.apache.bifromq.basecrdt.proto.Replica;

public class CausalCRDTInflaterFactory {
    private final String storeId;
    private final ScheduledExecutorService executor;
    private final Duration inflationInterval;
    private final Duration orHistoryExpiryTime;
    private final Duration maxCompactionTime;
    private final String[] tags;

    public CausalCRDTInflaterFactory(String storeId, Duration inflationInterval, Duration orHistoryExpiryTime, Duration maxCompactionTime, ScheduledExecutorService executor, String ... tags) {
        this.storeId = storeId;
        this.executor = executor;
        this.inflationInterval = inflationInterval;
        this.orHistoryExpiryTime = orHistoryExpiryTime;
        this.maxCompactionTime = maxCompactionTime;
        this.tags = tags;
    }

    public ICausalCRDTInflater<?, ?> create(Replica replicaId) {
        CRDTURI.checkURI(replicaId.getUri());
        InMemReplicaStateLattice lattice = new InMemReplicaStateLattice(this.storeId, replicaId, this.orHistoryExpiryTime, this.maxCompactionTime);
        return switch (CRDTURI.parseType(replicaId.getUri())) {
            default -> throw new IncompatibleClassChangeError();
            case CausalCRDTType.aworset -> new AWORSetInflater(this.storeId, replicaId, lattice, this.executor, this.inflationInterval, this.tags);
            case CausalCRDTType.rworset -> new RWORSetInflater(this.storeId, replicaId, lattice, this.executor, this.inflationInterval, this.tags);
            case CausalCRDTType.ormap -> new ORMapInflater(this.storeId, replicaId, lattice, this.executor, this.inflationInterval, this.tags);
            case CausalCRDTType.cctr -> new CCounterInflater(this.storeId, replicaId, lattice, this.executor, this.inflationInterval, this.tags);
            case CausalCRDTType.dwflag -> new DWFlagInflater(this.storeId, replicaId, lattice, this.executor, this.inflationInterval, this.tags);
            case CausalCRDTType.ewflag -> new EWFlagInflater(this.storeId, replicaId, lattice, this.executor, this.inflationInterval, this.tags);
            case CausalCRDTType.mvreg -> new MVRegInflater(this.storeId, replicaId, lattice, this.executor, this.inflationInterval, this.tags);
        };
    }
}

