/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bifromq.basecrdt.core.internal.DotFunc;
import org.apache.bifromq.basecrdt.core.internal.DotSet;
import org.apache.bifromq.basecrdt.core.internal.DotStore;
import org.apache.bifromq.basecrdt.core.internal.IDotFunc;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.IDotSet;
import org.apache.bifromq.basecrdt.proto.Dot;
import org.apache.bifromq.basecrdt.proto.StateLattice;

class DotMap
extends DotStore
implements IDotMap {
    public static final IDotMap BOTTOM = new DotMap();
    private final Map<ByteString, DotSet> dotSetMap = Maps.newConcurrentMap();
    private final Map<ByteString, DotFunc> dotFuncMap = Maps.newConcurrentMap();
    private final Map<ByteString, DotMap> dotMapMap = Maps.newConcurrentMap();

    DotMap() {
    }

    @Override
    public Optional<IDotSet> subDotSet(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        Optional<DotMap> parentMap = this.getParentMap(keys);
        return parentMap.map(dots -> dots.dotSetMap.get(keys[keys.length - 1]));
    }

    @Override
    public Optional<IDotFunc> subDotFunc(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        Optional<DotMap> parentMap = this.getParentMap(keys);
        return parentMap.map(dots -> dots.dotFuncMap.get(keys[keys.length - 1]));
    }

    @Override
    public Optional<IDotMap> subDotMap(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        Optional<DotMap> parentMap = this.getParentMap(keys);
        return parentMap.map(dots -> dots.dotMapMap.get(keys[keys.length - 1]));
    }

    @Override
    public Iterator<ByteString> dotSetKeys() {
        return this.dotSetMap.keySet().iterator();
    }

    @Override
    public Iterator<ByteString> dotFuncKeys() {
        return this.dotFuncMap.keySet().iterator();
    }

    @Override
    public Iterator<ByteString> dotMapKeys(ByteString ... keys) {
        if (keys.length == 0) {
            return this.dotMapMap.keySet().iterator();
        }
        Optional<DotMap> parentMap = this.getParentMap(keys);
        return parentMap.map(dots -> dots.dotMapMap.get((Object)keys[keys.length - 1]).dotMapMap.keySet().iterator()).orElse(Collections.emptyIterator());
    }

    @Override
    public boolean isBottom() {
        return this.dotSetMap.isEmpty() && this.dotFuncMap.isEmpty() && this.dotMapMap.isEmpty();
    }

    @Override
    public Iterator<Dot> iterator() {
        return Iterators.concat((Iterator)Iterators.concat(this.dotSetMap.values().stream().map(DotSet::iterator).iterator()), (Iterator)Iterators.concat(this.dotFuncMap.values().stream().map(DotFunc::iterator).iterator()), (Iterator)Iterators.concat(this.dotMapMap.values().stream().map(DotMap::iterator).iterator()));
    }

    @Override
    boolean add(StateLattice addState) {
        assert (addState.getStateTypeCase() == StateLattice.StateTypeCase.SINGLEMAP);
        ByteString key = addState.getSingleMap().getKey();
        StateLattice val = addState.getSingleMap().getVal();
        AtomicBoolean inflated = new AtomicBoolean();
        switch (val.getStateTypeCase()) {
            case SINGLEDOT: {
                this.dotSetMap.compute(key, (k, v) -> {
                    if (v == null) {
                        v = new DotSet();
                    }
                    inflated.set(v.add(val));
                    return v;
                });
                break;
            }
            case SINGLEVALUE: {
                this.dotFuncMap.compute(key, (k, v) -> {
                    if (v == null) {
                        v = new DotFunc();
                    }
                    inflated.set(v.add(val));
                    return v;
                });
                break;
            }
            case SINGLEMAP: {
                this.dotMapMap.compute(key, (k, v) -> {
                    if (v == null) {
                        v = new DotMap();
                    }
                    inflated.set(v.add(val));
                    return v;
                });
            }
        }
        return inflated.get();
    }

    @Override
    boolean remove(StateLattice removeState) {
        assert (removeState.getStateTypeCase() == StateLattice.StateTypeCase.SINGLEMAP);
        ByteString key = removeState.getSingleMap().getKey();
        StateLattice val = removeState.getSingleMap().getVal();
        AtomicBoolean inflated = new AtomicBoolean();
        switch (val.getStateTypeCase()) {
            case SINGLEDOT: {
                this.dotSetMap.computeIfPresent(key, (k, v) -> {
                    inflated.set(v.remove(val));
                    if (v.isBottom()) {
                        return null;
                    }
                    return v;
                });
                break;
            }
            case SINGLEVALUE: {
                this.dotFuncMap.computeIfPresent(key, (k, v) -> {
                    inflated.set(v.remove(val));
                    if (v.isBottom()) {
                        return null;
                    }
                    return v;
                });
                break;
            }
            case SINGLEMAP: {
                this.dotMapMap.computeIfPresent(key, (k, v) -> {
                    inflated.set(v.remove(val));
                    if (v.isBottom()) {
                        return null;
                    }
                    return v;
                });
            }
        }
        return inflated.get();
    }

    public String toString() {
        return "DotMap{dotSetMap=" + String.valueOf(this.dotSetMap) + ", dotFuncMap=" + String.valueOf(this.dotFuncMap) + ", dotMapMap=" + String.valueOf(this.dotMapMap) + "}";
    }

    private Optional<DotMap> getParentMap(ByteString ... keys) {
        DotMap m = this;
        for (int i = 0; i < keys.length - 1 && (m = m.dotMapMap.get(keys[i])) != null; ++i) {
        }
        return Optional.ofNullable(m);
    }
}

