/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.IRWORSet;
import org.apache.bifromq.basecrdt.core.api.IRWORSetInflater;
import org.apache.bifromq.basecrdt.core.api.RWORSetOperation;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDTInflater;
import org.apache.bifromq.basecrdt.core.internal.DotMap;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.IReplicaStateLattice;
import org.apache.bifromq.basecrdt.core.internal.RWORSet;
import org.apache.bifromq.basecrdt.core.internal.RWORSetCoalesceOperation;
import org.apache.bifromq.basecrdt.proto.Replica;

class RWORSetInflater
extends CausalCRDTInflater<IDotMap, RWORSetOperation, IRWORSet>
implements IRWORSetInflater {
    RWORSetInflater(String storeId, Replica replica, IReplicaStateLattice stateLattice, ScheduledExecutorService executor, Duration inflationInterval, String ... tags) {
        super(storeId, replica, stateLattice, executor, inflationInterval, tags);
    }

    @Override
    protected IRWORSet newCRDT(Replica replica, IDotMap dotStore, CausalCRDT.CRDTOperationExecutor<RWORSetOperation> executor) {
        return new RWORSet(replica, () -> dotStore, executor);
    }

    @Override
    public CausalCRDTType type() {
        return CausalCRDTType.rworset;
    }

    @Override
    protected ICoalesceOperation<IDotMap, RWORSetOperation> startCoalescing(RWORSetOperation op) {
        return new RWORSetCoalesceOperation(this.id().getId(), op);
    }

    @Override
    protected Class<? extends IDotMap> dotStoreType() {
        return DotMap.class;
    }
}

