/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.settingprovider;

import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CacheOptions {
    public static final CacheOptions DEFAULT = new SettingCacheOptions();

    public Duration refreshDuration();

    public int maxCachedTenants();

    public Duration expireDuration();

    public boolean provideInitValue();

    public static class SettingCacheOptions
    implements CacheOptions {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(SettingCacheOptions.class);
        public static final String SYS_PROP_PROVIDE_INIT_VALUE = "setting_provide_init_value";
        public static final String SYS_PROP_SETTING_REFRESH_SECONDS = "setting_refresh_seconds";
        public static final String SYS_PROP_SETTING_EXPIRE_SECONDS = "setting_expire_seconds";
        public static final String SYS_PROP_SETTING_TENANT_CACHE_LIMIT = "setting_tenant_cache_limit";
        private static final Duration DEFAULT_SETTING_REFRESH_SECONDS = Duration.ofSeconds(5L);
        private static final Duration DEFAULT_SETTING_EXPIRE_SECONDS = Duration.ofSeconds(300L);
        private static final int DEFAULT_MAX_CACHED_TENANTS = 100;
        private static final boolean PROVIDE_INIT_VALUE = false;

        @Override
        public boolean provideInitValue() {
            String override = System.getProperty(SYS_PROP_PROVIDE_INIT_VALUE);
            if (override != null) {
                try {
                    return Boolean.parseBoolean(override);
                }
                catch (Throwable e) {
                    log.error("Unable to parse 'setting_provide_init_value' value from system property: value={}", (Object)override);
                }
            }
            return false;
        }

        @Override
        public Duration refreshDuration() {
            String override = System.getProperty(SYS_PROP_SETTING_REFRESH_SECONDS);
            if (override != null) {
                try {
                    return Duration.ofSeconds(Long.parseLong(override));
                }
                catch (Throwable e) {
                    log.error("Unable to parse 'setting_refresh_seconds' value from system property: value={}", (Object)override);
                }
            }
            return DEFAULT_SETTING_REFRESH_SECONDS;
        }

        @Override
        public int maxCachedTenants() {
            String override = System.getProperty(SYS_PROP_SETTING_TENANT_CACHE_LIMIT);
            if (override != null) {
                try {
                    return Integer.parseInt(override);
                }
                catch (Throwable e) {
                    log.error("Unable to parse 'setting_tenant_cache_limit' value from system property: value={}", (Object)override);
                }
            }
            return 100;
        }

        @Override
        public Duration expireDuration() {
            String override = System.getProperty(SYS_PROP_SETTING_EXPIRE_SECONDS);
            if (override != null) {
                try {
                    return Duration.ofSeconds(Long.parseLong(override));
                }
                catch (Throwable e) {
                    log.error("Unable to parse 'setting_expire_seconds' value from system property: value={}", (Object)override);
                }
            }
            return DEFAULT_SETTING_EXPIRE_SECONDS;
        }
    }
}

