/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.kie.kogito.serverless.workflow.python;

import java.util.Collections;
import java.util.Map;

import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.serverless.workflow.WorkflowWorkItemHandler;

import jep.Interpreter;

import static org.kie.kogito.serverless.workflow.SWFConstants.PYTHON_SCRIPT;
import static org.kie.kogito.serverless.workflow.SWFConstants.SCRIPT;
import static org.kie.kogito.serverless.workflow.python.PythonWorkItemHandlerUtils.closeInterpreter;
import static org.kie.kogito.serverless.workflow.python.PythonWorkItemHandlerUtils.interpreter;

public class PythonScriptWorkItemHandler extends WorkflowWorkItemHandler {

    @Override
    public String getName() {
        return PYTHON_SCRIPT;
    }

    @Override
    protected Object internalExecute(KogitoWorkItem workItem, Map<String, Object> parameters) {
        Interpreter py = interpreter();
        String source = (String) parameters.remove(SCRIPT);
        parameters.forEach(py::set);
        py.exec(source);
        return Collections.emptyMap();
    }

    public void close() {
        closeInterpreter();
    }

}
