/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.recovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.server.recovery.JsonMapper;
import org.apache.livy.server.recovery.ZooKeeperManager$;
import org.apache.livy.utils.LivyUncaughtException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\r\u001b\u0001\u0015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)A\t\u0001C\u0001\u000b\")A\t\u0001C\u0001\u0013\"91\n\u0001b\u0001\n\u0013a\u0005BB+\u0001A\u0003%Q\nC\u0004W\u0001\t\u0007I\u0011\u0002'\t\r]\u0003\u0001\u0015!\u0003N\u0011\u001dA\u0006A1A\u0005\neCaA\u0019\u0001!\u0002\u0013Q\u0006\u0002C2\u0001\u0005\u0004%\tA\u00073\t\r-\u0004\u0001\u0015!\u0003f\u0011\u001da\u0007A1A\u0005\n5DaA\u001c\u0001!\u0002\u0013a\u0004\"B8\u0001\t\u0003\u0001\b\"\u0002;\u0001\t\u0003\u0001\b\"B;\u0001\t\u00031\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tY\u0006\u0001C\u0001\u0003;:\u0011\"!\u0019\u001b\u0003\u0003E\t!a\u0019\u0007\u0011eQ\u0012\u0011!E\u0001\u0003KBa\u0001\u0012\f\u0005\u0002\u0005\u001d\u0004\"CA5-E\u0005I\u0011AA6\u0005AQvn\\&fKB,'/T1oC\u001e,'O\u0003\u0002\u001c9\u0005A!/Z2pm\u0016\u0014\u0018P\u0003\u0002\u001e=\u000511/\u001a:wKJT!a\b\u0011\u0002\t1Lg/\u001f\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011C\u0006\r\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055rS\"\u0001\u000e\n\u0005=R\"A\u0003&t_:l\u0015\r\u001d9feB\u0011\u0011GM\u0007\u0002=%\u00111G\b\u0002\b\u0019><w-\u001b8h\u0003!a\u0017N^=D_:4\u0007CA\u00197\u0013\t9dD\u0001\u0005MSZL8i\u001c8g\u0003EiwnY6DkJ\fGo\u001c:DY&,g\u000e\u001e\t\u0004Oib\u0014BA\u001e)\u0005\u0019y\u0005\u000f^5p]B\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\nMJ\fW.Z<pe.T!!\u0011\u0011\u0002\u000f\r,(/\u0019;pe&\u00111I\u0010\u0002\u0011\u0007V\u0014\u0018\r^8s\rJ\fW.Z<pe.\fa\u0001P5oSRtDc\u0001$H\u0011B\u0011Q\u0006\u0001\u0005\u0006i\r\u0001\r!\u000e\u0005\bq\r\u0001\n\u00111\u0001:)\t1%\nC\u00035\t\u0001\u0007Q'A\u0005{W\u0006#GM]3tgV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!A.\u00198h\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V(\u0003\rM#(/\u001b8h\u0003)Q8.\u00113ee\u0016\u001c8\u000fI\u0001\u000be\u0016$(/\u001f,bYV,\u0017a\u0003:fiJLh+\u00197vK\u0002\nAB]3uef\u0004\u0016\r\u001e;fe:,\u0012A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b\u0001\"\\1uG\"Lgn\u001a\u0006\u0003?\"\nA!\u001e;jY&\u0011\u0011\r\u0018\u0002\u0006%\u0016<W\r_\u0001\u000ee\u0016$(/\u001f)biR,'O\u001c\u0011\u0002\u0017I,GO]=Q_2L7-_\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eQ\u0001\u0006e\u0016$(/_\u0005\u0003U\u001e\u00141BU3ueftE+[7fg\u0006a!/\u001a;ssB{G.[2zA\u0005i1-\u001e:bi>\u00148\t\\5f]R,\u0012\u0001P\u0001\u000fGV\u0014\u0018\r^8s\u00072LWM\u001c;!\u0003\u0015\u0019H/\u0019:u)\u0005\t\bCA\u0014s\u0013\t\u0019\bF\u0001\u0003V]&$\u0018\u0001B:u_B\f1a]3u)\u0011\tx/a\u0002\t\u000ba\f\u0002\u0019A=\u0002\u0007-,\u0017\u0010E\u0002{\u0003\u0007q!a_@\u0011\u0005qDS\"A?\u000b\u0005y$\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0002!\na\u0001\u0015:fI\u00164\u0017b\u0001+\u0002\u0006)\u0019\u0011\u0011\u0001\u0015\t\u000f\u0005%\u0011\u00031\u0001\u0002\f\u0005)a/\u00197vKB\u0019a*!\u0004\n\u0007\u0005=qJ\u0001\u0004PE*,7\r^\u0001\u0004O\u0016$X\u0003BA\u000b\u0003?!B!a\u0006\u0002BQ!\u0011\u0011DA\u0019!\u00119#(a\u0007\u0011\t\u0005u\u0011q\u0004\u0007\u0001\t\u001d\t\tC\u0005b\u0001\u0003G\u0011\u0011\u0001V\t\u0005\u0003K\tY\u0003E\u0002(\u0003OI1!!\u000b)\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aJA\u0017\u0013\r\ty\u0003\u000b\u0002\u0004\u0003:L\b\"CA\u001a%\u0005\u0005\t9AA\u001b\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003o\ti$a\u0007\u000e\u0005\u0005e\"bAA\u001eQ\u00059!/\u001a4mK\u000e$\u0018\u0002BA \u0003s\u0011\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006qJ\u0001\r!_\u0001\fO\u0016$8\t[5mIJ,g\u000e\u0006\u0003\u0002H\u0005e\u0003#BA%\u0003'Jh\u0002BA&\u0003\u001fr1\u0001`A'\u0013\u0005I\u0013bAA)Q\u00059\u0001/Y2lC\u001e,\u0017\u0002BA+\u0003/\u00121aU3r\u0015\r\t\t\u0006\u000b\u0005\u0006qN\u0001\r!_\u0001\u0007e\u0016lwN^3\u0015\u0007E\fy\u0006C\u0003y)\u0001\u0007\u00110\u0001\t[_>\\U-\u001a9fe6\u000bg.Y4feB\u0011QFF\n\u0003-\u0019\"\"!a\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiGK\u0002:\u0003_Z#!!\u001d\u0011\t\u0005M\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wB\u0013AC1o]>$\u0018\r^5p]&!\u0011qPA;\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ZooKeeperManager
implements JsonMapper,
Logging {
    private final LivyConf livyConf;
    private final String zkAddress;
    private final String retryValue;
    private final Regex retryPattern;
    private final RetryNTimes retryPolicy;
    private final CuratorFramework curatorClient;
    private Logger logger;
    private final ObjectMapper mapper;
    private volatile boolean bitmap$0;

    public static Option<CuratorFramework> $lessinit$greater$default$2() {
        return ZooKeeperManager$.MODULE$.$lessinit$greater$default$2();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public byte[] serializeToBytes(Object value) {
        return JsonMapper.serializeToBytes$(this, value);
    }

    @Override
    public <T> T deserialize(byte[] json, ClassTag<T> evidence$1) {
        return (T)JsonMapper.deserialize$(this, json, evidence$1);
    }

    private Logger logger$lzycompute() {
        ZooKeeperManager zooKeeperManager = this;
        synchronized (zooKeeperManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public ObjectMapper mapper() {
        return this.mapper;
    }

    @Override
    public void org$apache$livy$server$recovery$JsonMapper$_setter_$mapper_$eq(ObjectMapper x$1) {
        this.mapper = x$1;
    }

    private String zkAddress() {
        return this.zkAddress;
    }

    private String retryValue() {
        return this.retryValue;
    }

    private Regex retryPattern() {
        return this.retryPattern;
    }

    public RetryNTimes retryPolicy() {
        return this.retryPolicy;
    }

    private CuratorFramework curatorClient() {
        return this.curatorClient;
    }

    public void start() {
        this.curatorClient().start();
    }

    public void stop() {
        this.curatorClient().close();
    }

    public void set(String key, Object value) {
        byte[] data = this.serializeToBytes(value);
        if (this.curatorClient().checkExists().forPath(key) == null) {
            this.curatorClient().create().creatingParentsIfNeeded().forPath(key, data);
            return;
        }
        this.curatorClient().setData().forPath(key, data);
    }

    public <T> Option<T> get(String key, ClassTag<T> evidence$1) {
        if (this.curatorClient().checkExists().forPath(key) == null) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply(this.deserialize((byte[])this.curatorClient().getData().forPath(key), evidence$1));
    }

    public Seq<String> getChildren(String key) {
        if (this.curatorClient().checkExists().forPath(key) == null) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.curatorClient().getChildren().forPath(key)).asScala();
    }

    public void remove(String key) {
        try {
            this.curatorClient().delete().guaranteed().forPath(key);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Fail to remove non-existed zookeeper node: ").append(key).toString());
        }
    }

    public ZooKeeperManager(LivyConf livyConf, Option<CuratorFramework> mockCuratorClient) {
        this.livyConf = livyConf;
        JsonMapper.$init$(this);
        Logging.$init$((Logging)this);
        this.zkAddress = (String)Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.ZOOKEEPER_URL())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)$this.livyConf.get(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL()))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim()).orNull(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.require(this.zkAddress() != null && !this.zkAddress().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Please config ").append(LivyConf$.MODULE$.ZOOKEEPER_URL().key()).append(".").toString());
        this.retryValue = (String)Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.ZK_RETRY_POLICY())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)$this.livyConf.get(LivyConf$.MODULE$.RECOVERY_ZK_STATE_STORE_RETRY_POLICY()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim()).orNull(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.require(this.retryValue() != null && !this.retryValue().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Please config ").append(LivyConf$.MODULE$.ZK_RETRY_POLICY().key()).append(".").toString());
        this.retryPattern = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\d+)\\s*,\\s*(\\d+)\\s*")).r();
        String string = this.retryValue();
        Option option = this.retryPattern().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
            throw new IllegalArgumentException(new StringBuilder(94).append("contains bad value: ").append(this.retryValue()).append(". ").append("Correct format is <max retry count>,<sleep ms between retry>. e.g. 5,100").toString());
        }
        String n = (String)((LinearSeqOptimized)option.get()).apply(0);
        String sleepMs = (String)((LinearSeqOptimized)option.get()).apply(1);
        this.retryPolicy = new RetryNTimes(new StringOps(Predef$.MODULE$.augmentString(n)).toInt(), new StringOps(Predef$.MODULE$.augmentString(sleepMs)).toInt());
        this.curatorClient = (CuratorFramework)mockCuratorClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> CuratorFrameworkFactory.newClient((String)this.zkAddress(), (RetryPolicy)this.retryPolicy()));
        this.curatorClient().getUnhandledErrorListenable().addListener((Object)new UnhandledErrorListener(this){
            private final /* synthetic */ ZooKeeperManager $outer;

            public void unhandledError(String message, Throwable e) {
                this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Fatal Zookeeper error: ").append(message).append(".").toString(), e);
                throw new LivyUncaughtException(e.getMessage());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$unhandledError$1(java.lang.String )}, serializedLambda);
            }
        });
    }

    public ZooKeeperManager(LivyConf livyConf) {
        this(livyConf, (Option<CuratorFramework>)None$.MODULE$);
    }
}

