/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetastoreOperations {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetastoreOperations.class);

    protected CommitStatus checkCommitStatus(String tableOrViewName, String newMetadataLocation, Map<String, String> properties, Supplier<Boolean> commitStatusSupplier) {
        CommitStatus strictStatus = this.checkCommitStatusStrict(tableOrViewName, newMetadataLocation, properties, commitStatusSupplier);
        if (strictStatus == CommitStatus.FAILURE) {
            LOG.warn("Commit status check: Commit to {} of {} unknown, new metadata location is not current or in history", (Object)tableOrViewName, (Object)newMetadataLocation);
            return CommitStatus.UNKNOWN;
        }
        return strictStatus;
    }

    protected CommitStatus checkCommitStatusStrict(String tableOrViewName, String newMetadataLocation, Map<String, String> properties, Supplier<Boolean> commitStatusSupplier) {
        int maxAttempts = PropertyUtil.propertyAsInt(properties, "commit.status-check.num-retries", 3);
        long minWaitMs = PropertyUtil.propertyAsLong(properties, "commit.status-check.min-wait-ms", 1000L);
        long maxWaitMs = PropertyUtil.propertyAsLong(properties, "commit.status-check.max-wait-ms", 60000L);
        long totalRetryMs = PropertyUtil.propertyAsLong(properties, "commit.status-check.total-timeout-ms", 1800000L);
        AtomicReference<CommitStatus> status = new AtomicReference<CommitStatus>(CommitStatus.UNKNOWN);
        Tasks.foreach(newMetadataLocation).retry(maxAttempts).suppressFailureWhenFinished().exponentialBackoff(minWaitMs, maxWaitMs, totalRetryMs, 2.0).onFailure((location, checkException) -> LOG.error("Cannot check if commit to {} exists.", (Object)tableOrViewName, (Object)checkException)).run(location -> {
            boolean commitSuccess = (Boolean)commitStatusSupplier.get();
            if (commitSuccess) {
                LOG.info("Commit status check: Commit to {} of {} succeeded", (Object)tableOrViewName, (Object)newMetadataLocation);
                status.set(CommitStatus.SUCCESS);
            } else {
                status.set(CommitStatus.FAILURE);
            }
        });
        if (status.get() == CommitStatus.UNKNOWN) {
            LOG.error("Cannot determine commit state to {}. Failed during checking {} times. Treating commit state as unknown.", (Object)tableOrViewName, (Object)maxAttempts);
        }
        return status.get();
    }

    public static enum CommitStatus {
        FAILURE,
        SUCCESS,
        UNKNOWN;

    }
}

