/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;

public class CreatePolicyRequest {
    @NotNull
    @Pattern(regexp="^[A-Za-z0-9\\-_]+$")
    private final @NotNull @Pattern(regexp="^[A-Za-z0-9\\-_]+$") String name;
    @NotNull
    private final String type;
    private final String description;
    private final String content;

    @ApiModelProperty(example="compaction", required=true, value="A policy name. A valid policy name should only consist of uppercase and lowercase letters (A-Z, a-z), digits (0-9), hyphens (-), underscores (_).")
    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type", required=true)
    public String getType() {
        return this.type;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @JsonCreator
    public CreatePolicyRequest(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type", required=true) String type, @JsonProperty(value="description") String description, @JsonProperty(value="content") String content) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.content = content;
    }

    public CreatePolicyRequest(String name, String type) {
        this.name = name;
        this.type = type;
        this.description = null;
        this.content = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name, String type) {
        return new Builder(name, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePolicyRequest createPolicyRequest = (CreatePolicyRequest)o;
        return Objects.equals(this.name, createPolicyRequest.name) && Objects.equals(this.type, createPolicyRequest.type) && Objects.equals(this.description, createPolicyRequest.description) && Objects.equals(this.content, createPolicyRequest.content);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.description, this.content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePolicyRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String name;
        private String type;
        private String description;
        private String content;

        private Builder() {
        }

        private Builder(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public CreatePolicyRequest build() {
            CreatePolicyRequest inst = new CreatePolicyRequest(this.name, this.type, this.description, this.content);
            return inst;
        }
    }
}

