/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;

@FunctionalInterface
public interface PrincipalSecretsGenerator {
    public static final PrincipalSecretsGenerator RANDOM_SECRETS = (name, id) -> new PolarisPrincipalSecrets(id);

    public PolarisPrincipalSecrets produceSecrets(@Nonnull String var1, long var2);

    public static PrincipalSecretsGenerator bootstrap(String realmName) {
        return PrincipalSecretsGenerator.bootstrap(realmName, RootCredentialsSet.fromEnvironment());
    }

    public static PrincipalSecretsGenerator bootstrap(String realmName, @Nullable RootCredentialsSet rootCredentialsSet) {
        return (principalName, principalId) -> Optional.ofNullable(rootCredentialsSet).flatMap(credentialsSet -> PrincipalSecretsGenerator.getSecrets(realmName, principalName, principalId, credentialsSet)).orElseGet(() -> RANDOM_SECRETS.produceSecrets(principalName, principalId));
    }

    private static Optional<PolarisPrincipalSecrets> getSecrets(String realmName, String principalName, long principalId, RootCredentialsSet rootCredentialsSet) {
        if (principalName.equals(PolarisEntityConstants.getRootPrincipalName())) {
            return Optional.ofNullable(rootCredentialsSet.credentials().get(realmName)).map(credentials -> {
                String clientId = credentials.clientId();
                String secret = credentials.clientSecret();
                return new PolarisPrincipalSecrets(principalId, clientId, secret, secret);
            });
        }
        return Optional.empty();
    }
}

