/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.azure;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureLocation;
import org.apache.polaris.core.storage.azure.ImmutableAzureStorageConfigurationInfo;
import org.apache.polaris.immutables.PolarisImmutable;

@JsonSerialize(as=ImmutableAzureStorageConfigurationInfo.class)
@JsonDeserialize(as=ImmutableAzureStorageConfigurationInfo.class)
@JsonTypeName(value="AzureStorageConfigurationInfo")
@PolarisImmutable
public abstract class AzureStorageConfigurationInfo
extends PolarisStorageConfigurationInfo {
    public static ImmutableAzureStorageConfigurationInfo.Builder builder() {
        return ImmutableAzureStorageConfigurationInfo.builder();
    }

    @Override
    public String getFileIoImplClassName() {
        return "org.apache.iceberg.azure.adlsv2.ADLSFileIO";
    }

    @Override
    public PolarisStorageConfigurationInfo.StorageType getStorageType() {
        return PolarisStorageConfigurationInfo.StorageType.AZURE;
    }

    public abstract String getTenantId();

    @Nullable
    public abstract String getMultiTenantAppName();

    @Nullable
    public abstract String getConsentUrl();

    @Override
    public void validatePrefixForStorageType(String loc) {
        AzureLocation location = new AzureLocation(loc);
        Objects.requireNonNull(location);
    }
}

