/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NodeIdConversions {
    private NodeIdConversions() {
    }

    @NotNull
    static ExpandedNodeId nodeIdToExpandedNodeId(@NotNull NodeId nodeId) {
        return nodeId.expanded();
    }

    @NotNull
    static String nodeIdToString(@NotNull NodeId nodeId) {
        return nodeId.toParseableString();
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof NodeId) {
            NodeId nodeId = (NodeId)o;
            return implicit ? NodeIdConversions.implicitConversion(nodeId, targetType) : NodeIdConversions.explicitConversion(nodeId, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull NodeId nodeId, BuiltinDataType targetType) {
        return NodeIdConversions.implicitConversion(nodeId, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull NodeId nodeId, BuiltinDataType targetType) {
        switch (targetType) {
            case ExpandedNodeId: {
                return NodeIdConversions.nodeIdToExpandedNodeId(nodeId);
            }
            case String: {
                return NodeIdConversions.nodeIdToString(nodeId);
            }
        }
        return null;
    }
}

