/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionEventLoop
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(SessionEventLoop.class);
    private final BlockingQueue<FutureTask<String>> taskQueue;
    private final boolean flushOnExit;

    public SessionEventLoop(BlockingQueue<FutureTask<String>> taskQueue) {
        this(taskQueue, true);
    }

    public SessionEventLoop(BlockingQueue<FutureTask<String>> taskQueue, boolean flushOnExit) {
        this.taskQueue = taskQueue;
        this.flushOnExit = flushOnExit;
    }

    @Override
    public void run() {
        while (!Thread.interrupted() || Thread.interrupted() && !this.taskQueue.isEmpty() && this.flushOnExit) {
            try {
                FutureTask<String> task = this.taskQueue.take();
                SessionEventLoop.executeTask(task);
            }
            catch (InterruptedException e) {
                LOG.info("SessionEventLoop {} interrupted", (Object)Thread.currentThread().getName());
                Thread.currentThread().interrupt();
            }
        }
        LOG.info("SessionEventLoop {} exit", (Object)Thread.currentThread().getName());
    }

    public static void executeTask(FutureTask<String> task) {
        if (!task.isCancelled()) {
            try {
                task.run();
                task.get();
            }
            catch (Throwable th) {
                LOG.warn("SessionEventLoop {} reached exception in processing command", (Object)Thread.currentThread().getName(), (Object)th);
                throw new RuntimeException(th);
            }
        }
    }
}

