/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BrowsePathResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=549");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=551");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=550");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15192");
    private final StatusCode statusCode;
    private final BrowsePathTarget[] targets;

    public BrowsePathResult(StatusCode statusCode, BrowsePathTarget[] targets) {
        this.statusCode = statusCode;
        this.targets = targets;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public BrowsePathTarget[] getTargets() {
        return this.targets;
    }

    protected BrowsePathResult(BrowsePathResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((BrowsePathResultBuilder)b).statusCode;
        this.targets = ((BrowsePathResultBuilder)b).targets;
    }

    public static BrowsePathResultBuilder<?, ?> builder() {
        return new BrowsePathResultBuilderImpl();
    }

    public BrowsePathResultBuilder<?, ?> toBuilder() {
        return new BrowsePathResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowsePathResult)) {
            return false;
        }
        BrowsePathResult other = (BrowsePathResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        return Arrays.deepEquals(this.getTargets(), other.getTargets());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowsePathResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTargets());
        return result;
    }

    @Override
    public String toString() {
        return "BrowsePathResult(statusCode=" + this.getStatusCode() + ", targets=" + Arrays.deepToString(this.getTargets()) + ")";
    }

    private static final class BrowsePathResultBuilderImpl
    extends BrowsePathResultBuilder<BrowsePathResult, BrowsePathResultBuilderImpl> {
        private BrowsePathResultBuilderImpl() {
        }

        @Override
        protected BrowsePathResultBuilderImpl self() {
            return this;
        }

        @Override
        public BrowsePathResult build() {
            return new BrowsePathResult(this);
        }
    }

    public static abstract class BrowsePathResultBuilder<C extends BrowsePathResult, B extends BrowsePathResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private BrowsePathTarget[] targets;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrowsePathResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrowsePathResult instance, BrowsePathResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.targets(instance.targets);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B targets(BrowsePathTarget[] targets) {
            this.targets = targets;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrowsePathResult.BrowsePathResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", targets=" + Arrays.deepToString(this.targets) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowsePathResult> {
        @Override
        public Class<BrowsePathResult> getType() {
            return BrowsePathResult.class;
        }

        @Override
        public BrowsePathResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            BrowsePathTarget[] targets = (BrowsePathTarget[])decoder.readStructArray("Targets", BrowsePathTarget.TYPE_ID);
            return new BrowsePathResult(statusCode, targets);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowsePathResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeStructArray("Targets", (Object[])value.getTargets(), BrowsePathTarget.TYPE_ID);
        }
    }
}

