/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModsOperationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModsOperationUtil.class);

    private ModsOperationUtil() {
    }

    public static PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> loadModificationsFromTsFile(File tsFile) {
        PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications = PatternTreeMapFactory.getModsPatternTreeMap();
        try (ModificationFile file = new ModificationFile(tsFile.getPath() + ".mods");){
            file.getModifications().forEach(modification -> modifications.append(modification.getPath(), modification));
        }
        catch (Exception e) {
            throw new PipeException("Failed to load modifications from TsFile: " + tsFile.getPath(), (Throwable)e);
        }
        return modifications;
    }

    public static boolean isAllDeletedByMods(String deviceID, String measurementID, long startTime, long endTime, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications) {
        if (modifications == null) {
            return false;
        }
        List mods = null;
        try {
            mods = modifications.getOverlapped(CompactionPathUtils.getPath(deviceID, measurementID));
        }
        catch (IllegalPathException ignore) {
            LOGGER.warn("Failed to get mods for device {} and measurement {}", (Object)deviceID, (Object)measurementID);
        }
        if (mods == null || mods.isEmpty()) {
            return false;
        }
        return mods.stream().anyMatch(modification -> ((Deletion)modification).getTimeRange().contains(startTime, endTime));
    }

    public static List<ModsInfo> initializeMeasurementMods(String deviceID, List<String> measurements, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications) {
        ArrayList<ModsInfo> modsInfos = new ArrayList<ModsInfo>(measurements.size());
        for (String measurement : measurements) {
            List mods;
            try {
                mods = modifications.getOverlapped(CompactionPathUtils.getPath(deviceID, measurement));
            }
            catch (IllegalPathException ignore) {
                mods = null;
                LOGGER.warn("Failed to get mods for device {} and measurement {}", (Object)deviceID, (Object)measurement);
            }
            if (mods == null || mods.isEmpty()) {
                modsInfos.add(new ModsInfo(Collections.emptyList(), 0));
                continue;
            }
            modsInfos.add(new ModsInfo(ModsOperationUtil.modificationConvertionToDeletions(ModificationFile.sortAndMerge(mods)), 0));
        }
        return modsInfos;
    }

    public static List<Deletion> modificationConvertionToDeletions(List<Modification> modifications) {
        ArrayList<Deletion> deletions = new ArrayList<Deletion>();
        for (Modification modification : modifications) {
            if (!(modification instanceof Deletion)) continue;
            deletions.add((Deletion)modification);
        }
        return deletions;
    }

    public static boolean isDelete(long time, ModsInfo modsInfo) {
        if (modsInfo == null) {
            return false;
        }
        List<Deletion> mods = modsInfo.getMods();
        if (mods == null || mods.isEmpty()) {
            return false;
        }
        int currentIndex = modsInfo.getCurrentIndex();
        if (currentIndex < 0) {
            return false;
        }
        if (currentIndex < mods.size()) {
            Deletion currentMod = mods.get(currentIndex);
            long currentModStartTime = currentMod.getTimeRange().getMin();
            long currentModEndTime = currentMod.getTimeRange().getMax();
            if (time < currentModStartTime) {
                return false;
            }
            if (time <= currentModEndTime) {
                return true;
            }
            return ModsOperationUtil.searchAndCheckMod(mods, time, currentIndex + 1, modsInfo);
        }
        ModsOperationUtil.clearModsAndReset(modsInfo);
        return false;
    }

    private static boolean searchAndCheckMod(List<Deletion> mods, long time, int startIndex, ModsInfo modsInfo) {
        int searchIndex = ModsOperationUtil.binarySearchMods(mods, time, startIndex);
        if (searchIndex >= mods.size()) {
            ModsOperationUtil.clearModsAndReset(modsInfo);
            return false;
        }
        Deletion foundMod = mods.get(searchIndex);
        long foundModStartTime = foundMod.getTimeRange().getMin();
        if (time < foundModStartTime) {
            modsInfo.setCurrentIndex(searchIndex);
            return false;
        }
        modsInfo.setCurrentIndex(searchIndex);
        return true;
    }

    private static void clearModsAndReset(ModsInfo modsInfo) {
        modsInfo.setMods(Collections.emptyList());
        modsInfo.setCurrentIndex(0);
    }

    private static int binarySearchMods(List<Deletion> mods, long time, int startIndex) {
        int left = startIndex;
        int right = mods.size();
        while (left < right) {
            int mid = left + (right - left) / 2;
            long max = mods.get(mid).getTimeRange().getMax();
            if (max < time) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        return left;
    }

    public static class ModsInfo {
        private List<Deletion> mods;
        private int currentIndex;

        public ModsInfo(List<Deletion> mods, int currentIndex) {
            this.mods = mods;
            this.currentIndex = currentIndex;
        }

        public List<Deletion> getMods() {
            return this.mods;
        }

        public void setMods(List<Deletion> newMods) {
            this.mods = newMods;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public void setCurrentIndex(int newIndex) {
            this.currentIndex = newIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModsInfo modsInfo = (ModsInfo)o;
            return Objects.equals(this.mods, modsInfo.mods) && Objects.equals(this.currentIndex, modsInfo.currentIndex);
        }

        public int hashCode() {
            return Objects.hash(this.mods, this.currentIndex);
        }

        public String toString() {
            return "ModsInfo{mods=" + this.mods + ", currentIndex=" + this.currentIndex + '}';
        }
    }
}

