/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.jetbrains.annotations.Nullable;

public interface NodeManager<T extends Node> {
    public boolean containsNode(NodeId var1);

    public boolean containsNode(ExpandedNodeId var1, NamespaceTable var2);

    public Optional<T> addNode(T var1);

    public Optional<T> getNode(NodeId var1);

    public Optional<T> getNode(ExpandedNodeId var1, NamespaceTable var2);

    public Optional<T> removeNode(NodeId var1);

    public Optional<T> removeNode(ExpandedNodeId var1, NamespaceTable var2);

    public void addReference(Reference var1);

    public void addReferences(Reference var1, NamespaceTable var2);

    public void removeReference(Reference var1);

    public void removeReferences(Reference var1, NamespaceTable var2);

    public List<Reference> getReferences(NodeId var1);

    public List<Reference> getReferences(NodeId var1, Predicate<Reference> var2);

    default public boolean containsNode(Node node) {
        return this.containsNode(node.getNodeId());
    }

    @Nullable
    default public T get(NodeId nodeId) {
        return (T)((Node)this.getNode(nodeId).orElse(null));
    }

    @Nullable
    default public T get(ExpandedNodeId nodeId, NamespaceTable namespaceTable) {
        return (T)((Node)this.getNode(nodeId, namespaceTable).orElse(null));
    }

    default public Optional<T> removeNode(T node) {
        return this.removeNode((T)node.getNodeId());
    }
}

