/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.services;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.EventItem;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;

public interface MonitoredItemServices {
    default public void onCreateDataItem(ReadValueId itemToMonitor, Double requestedSamplingInterval, UInteger requestedQueueSize, BiConsumer<Double, UInteger> revisionCallback) {
        revisionCallback.accept(requestedSamplingInterval, requestedQueueSize);
    }

    default public void onModifyDataItem(ReadValueId itemToModify, Double requestedSamplingInterval, UInteger requestedQueueSize, BiConsumer<Double, UInteger> revisionCallback) {
        revisionCallback.accept(requestedSamplingInterval, requestedQueueSize);
    }

    default public void onCreateEventItem(ReadValueId itemToMonitor, UInteger requestedQueueSize, Consumer<UInteger> revisionCallback) {
        revisionCallback.accept(requestedQueueSize);
    }

    default public void onModifyEventItem(ReadValueId itemToModify, UInteger requestedQueueSize, Consumer<UInteger> revisionCallback) {
        revisionCallback.accept(requestedQueueSize);
    }

    public void onDataItemsCreated(List<DataItem> var1);

    public void onDataItemsModified(List<DataItem> var1);

    public void onDataItemsDeleted(List<DataItem> var1);

    default public void onEventItemsCreated(List<EventItem> eventItems) {
    }

    default public void onEventItemsModified(List<EventItem> eventItems) {
    }

    default public void onEventItemsDeleted(List<EventItem> eventItems) {
    }

    public void onMonitoringModeChanged(List<MonitoredItem> var1);
}

