/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.LastAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;

public class LastDescAccumulator
extends LastAccumulator {
    public LastDescAccumulator(TSDataType seriesDataType, boolean isTimeColumn) {
        super(seriesDataType, isTimeColumn);
    }

    @Override
    public TableAccumulator copy() {
        return new LastDescAccumulator(this.seriesDataType, this.isTimeColumn);
    }

    @Override
    public boolean hasFinalResult() {
        return this.initResult;
    }

    @Override
    protected void addIntInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateIntLastValue(valueColumn.getInt(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateIntLastValue(valueColumn.getInt(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addLongInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateLongLastValue(valueColumn.getLong(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateLongLastValue(valueColumn.getLong(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addFloatInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateFloatLastValue(valueColumn.getFloat(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateFloatLastValue(valueColumn.getFloat(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addDoubleInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateDoubleLastValue(valueColumn.getDouble(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateDoubleLastValue(valueColumn.getDouble(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addBinaryInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBinaryLastValue(valueColumn.getBinary(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBinaryLastValue(valueColumn.getBinary(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addBooleanInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBooleanLastValue(valueColumn.getBoolean(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBooleanLastValue(valueColumn.getBoolean(position), timeColumn.getLong(position));
                return;
            }
        }
    }
}

