/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.storageengine.dataregion.modification.IDPredicate;
import org.apache.iotdb.db.utils.io.BufferSerializable;
import org.apache.iotdb.db.utils.io.StreamSerializable;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DeletionPredicate
implements StreamSerializable,
BufferSerializable {
    private String tableName;
    private IDPredicate idPredicate = new IDPredicate.NOP();
    private List<String> measurementNames = Collections.emptyList();

    public DeletionPredicate() {
    }

    public DeletionPredicate(String tableName) {
        this.tableName = tableName;
    }

    public DeletionPredicate(String tableName, IDPredicate idPredicate) {
        this.tableName = tableName;
        this.idPredicate = idPredicate;
    }

    public DeletionPredicate(String tableName, IDPredicate idPredicate, List<String> measurementNames) {
        this.tableName = tableName;
        this.idPredicate = idPredicate;
        this.measurementNames = measurementNames;
    }

    public boolean matches(IDeviceID deviceID) {
        return this.tableName.equals(deviceID.getTableName()) && this.idPredicate.matches(deviceID);
    }

    public void setIdPredicate(IDPredicate idPredicate) {
        this.idPredicate = idPredicate;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getMeasurementNames() {
        return this.measurementNames;
    }

    public boolean affects(String measurementName) {
        return this.measurementNames.isEmpty() || this.measurementNames.contains(measurementName);
    }

    @Override
    public long serialize(OutputStream stream) throws IOException {
        long size = ReadWriteIOUtils.writeVar((String)this.tableName, (OutputStream)stream);
        size += this.idPredicate.serialize(stream);
        size += (long)ReadWriteForEncodingUtils.writeVarInt((int)this.measurementNames.size(), (OutputStream)stream);
        for (String measurementName : this.measurementNames) {
            size += (long)ReadWriteIOUtils.writeVar((String)measurementName, (OutputStream)stream);
        }
        return size;
    }

    @Override
    public long serialize(ByteBuffer buffer) {
        long size = ReadWriteIOUtils.writeVar((String)this.tableName, (ByteBuffer)buffer);
        size += this.idPredicate.serialize(buffer);
        size += (long)ReadWriteForEncodingUtils.writeVarInt((int)this.measurementNames.size(), (ByteBuffer)buffer);
        for (String measurementName : this.measurementNames) {
            size += (long)ReadWriteIOUtils.writeVar((String)measurementName, (ByteBuffer)buffer);
        }
        return size;
    }

    @Override
    public void deserialize(InputStream stream) throws IOException {
        this.tableName = ReadWriteIOUtils.readVarIntString((InputStream)stream);
        this.idPredicate = IDPredicate.createFrom(stream);
        int measurementLength = ReadWriteForEncodingUtils.readVarInt((InputStream)stream);
        if (measurementLength > 0) {
            this.measurementNames = new ArrayList<String>(measurementLength);
            for (int i = 0; i < measurementLength; ++i) {
                this.measurementNames.add(ReadWriteIOUtils.readVarIntString((InputStream)stream));
            }
        } else {
            this.measurementNames = Collections.emptyList();
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.tableName = ReadWriteIOUtils.readVarIntString((ByteBuffer)buffer);
        this.idPredicate = IDPredicate.createFrom(buffer);
        int measurementLength = ReadWriteForEncodingUtils.readVarInt((ByteBuffer)buffer);
        if (measurementLength > 0) {
            this.measurementNames = new ArrayList<String>(measurementLength);
            for (int i = 0; i < measurementLength; ++i) {
                this.measurementNames.add(ReadWriteIOUtils.readVarIntString((ByteBuffer)buffer));
            }
        } else {
            this.measurementNames = Collections.emptyList();
        }
    }

    public int serializedSize() {
        int size = ReadWriteForEncodingUtils.varIntSize((int)this.tableName.length()) + this.tableName.length() * 2 + this.idPredicate.serializedSize() + ReadWriteForEncodingUtils.varIntSize((int)this.measurementNames.size());
        for (String measurementName : this.measurementNames) {
            size += ReadWriteForEncodingUtils.varIntSize((int)(measurementName.length() * measurementName.length() * 2));
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletionPredicate that = (DeletionPredicate)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.idPredicate, that.idPredicate) && Objects.equals(this.measurementNames, that.measurementNames);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.idPredicate, this.measurementNames);
    }

    public String toString() {
        return "DeletionPredicate{tableName='" + this.tableName + '\'' + ", idPredicate=" + this.idPredicate + ", measurementNames=" + this.measurementNames + '}';
    }
}

