/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class MappingArgument {
    public static final String CONFIGURATION_ERROR_MESSAGE = "Invalid format, please respect key1;value1,key2;value2 format";

    public static ImmutableMap<String, String> parse(String mapping) {
        Preconditions.checkArgument((mapping != null ? 1 : 0) != 0, (Object)"mapping should not be null");
        if (mapping.trim().isEmpty()) {
            return ImmutableMap.of();
        }
        return (ImmutableMap)Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)mapping).stream().map(MappingArgument::parseKeyValue).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
    }

    private static Pair<String, String> parseKeyValue(String keyValue) {
        List pair = Splitter.on((char)';').trimResults().splitToList((CharSequence)keyValue);
        if (pair.size() != 2) {
            throw new IllegalArgumentException(CONFIGURATION_ERROR_MESSAGE);
        }
        return Pair.of((Object)((String)pair.get(0)), (Object)((String)pair.get(1)));
    }
}

