/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.linshare;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AuthorizationToken {
    private final String value;

    @VisibleForTesting
    public AuthorizationToken(@JsonProperty(value="token") String value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"token value cannot be null or blank");
        this.value = value;
    }

    public String asBearerHeader() {
        return "Bearer " + this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof AuthorizationToken) {
            AuthorizationToken that = (AuthorizationToken)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }
}

