/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.MetricAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class StringStatsAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean showDistribution;
    public static final JsonpDeserializer<StringStatsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StringStatsAggregation::setupStringStatsAggregationDeserializer);

    private StringStatsAggregation(Builder builder) {
        super(builder);
        this.showDistribution = builder.showDistribution;
    }

    public static StringStatsAggregation of(Function<Builder, ObjectBuilder<StringStatsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.StringStats;
    }

    @Nullable
    public final Boolean showDistribution() {
        return this.showDistribution;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.showDistribution != null) {
            generator.writeKey("show_distribution");
            generator.write(this.showDistribution.booleanValue());
        }
    }

    protected static void setupStringStatsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        StringStatsAggregation.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::showDistribution, JsonpDeserializer.booleanDeserializer(), "show_distribution");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StringStatsAggregation> {
        @Nullable
        private Boolean showDistribution;

        public final Builder showDistribution(@Nullable Boolean value) {
            this.showDistribution = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StringStatsAggregation build() {
            this._checkSingleUse();
            return new StringStatsAggregation(this);
        }
    }
}

