/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RedactedValueException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.TokenizedValueException;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BooleanLogFieldSyntax
extends LogFieldSyntax<Boolean> {
    @NotNull
    public static final String SYNTAX_NAME = "boolean";
    @NotNull
    private static final BooleanLogFieldSyntax INSTANCE = new BooleanLogFieldSyntax();

    private BooleanLogFieldSyntax() {
        super(100);
    }

    @NotNull
    public static BooleanLogFieldSyntax getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    @NotNull
    public String valueToSanitizedString(@NotNull Boolean value) {
        return value.toString();
    }

    @Override
    public void valueToSanitizedString(@NotNull Boolean value, @NotNull ByteStringBuffer buffer) {
        buffer.append(value);
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Boolean fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append('=');
        buffer.append(fieldValue.toString());
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Boolean fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendBoolean(fieldName, fieldValue);
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull Boolean value, @NotNull JSONBuffer buffer) {
        buffer.appendBoolean(value);
    }

    @Override
    @NotNull
    public Boolean parseValue(@NotNull String valueString) throws RedactedValueException, TokenizedValueException, LogSyntaxException {
        String lowerValue = StaticUtils.toLowerCase(valueString);
        if (lowerValue.equals("true")) {
            return Boolean.TRUE;
        }
        if (lowerValue.equals("false")) {
            return Boolean.FALSE;
        }
        if (this.valueStringIncludesRedactedComponent(valueString)) {
            throw new RedactedValueException(LogSyntaxMessages.ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE_REDACTED.get());
        }
        if (this.valueStringIncludesTokenizedComponent(valueString)) {
            throw new TokenizedValueException(LogSyntaxMessages.ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED.get());
        }
        throw new LogSyntaxException(LogSyntaxMessages.ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE.get());
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return false;
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"{REDACTED}\"");
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, "{REDACTED}");
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendString("{REDACTED}");
    }

    @Override
    public boolean supportsRedactedComponents() {
        return false;
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return false;
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Boolean fieldValue, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyRedactedFieldToTextFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Boolean fieldValue, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedFieldToJSONFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull Boolean value, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedValueToJSONFormattedLog(buffer);
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return false;
    }

    @Override
    public void tokenizeEntireValue(@NotNull Boolean value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.tokenize(value.toString(), pepper, buffer);
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Boolean fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenize(fieldValue.toString(), pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Boolean fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenize(fieldValue.toString(), pepper));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull Boolean value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenize(value.toString(), pepper));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return false;
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return false;
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Boolean fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyTokenizedFieldToTextFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Boolean fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedFieldToJSONFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull Boolean value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedValueToJSONFormattedLog(value, pepper, buffer);
    }
}

