/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.identification.BrowseGraphic;

@XmlType(name="CI_Organisation_Type", propOrder={"logo", "individual"})
@XmlRootElement(name="CI_Organisation")
@UML(identifier="CI_Organisation", specification=Specification.ISO_19115)
public class DefaultOrganisation
extends AbstractParty {
    private static final long serialVersionUID = 5113656476176154532L;
    private Collection<BrowseGraphic> logo;
    private Collection<DefaultIndividual> individual;

    public DefaultOrganisation() {
    }

    public DefaultOrganisation(CharSequence name, BrowseGraphic logo, DefaultIndividual individual, Contact contactInfo) {
        super(name, contactInfo);
        this.logo = this.singleton(logo, BrowseGraphic.class);
        this.individual = this.singleton(individual, DefaultIndividual.class);
    }

    public DefaultOrganisation(DefaultOrganisation object) {
        super(object);
        if (object != null) {
            this.logo = this.copyCollection(object.getLogo(), BrowseGraphic.class);
            this.individual = this.copyCollection(object.getIndividual(), DefaultIndividual.class);
        }
    }

    @XmlElement(name="logo")
    @UML(identifier="logo", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<BrowseGraphic> getLogo() {
        this.logo = this.nonNullCollection(this.logo, BrowseGraphic.class);
        return this.logo;
    }

    public void setLogo(Collection<? extends BrowseGraphic> newValues) {
        this.logo = this.writeCollection(newValues, this.logo, BrowseGraphic.class);
    }

    @XmlElement(name="individual")
    @UML(identifier="individual", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultIndividual> getIndividual() {
        this.individual = this.nonNullCollection(this.individual, DefaultIndividual.class);
        return this.individual;
    }

    public void setIndividual(Collection<? extends DefaultIndividual> newValues) {
        this.individual = this.writeCollection(newValues, this.individual, DefaultIndividual.class);
    }
}

