/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Method;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.reflect.ConfigAnnotationFilter;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodProperties;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public class RestMethodContextBuilder
extends BeanContextBuilder {
    RestContext context;
    Method method;
    RestMethodProperties properties;

    RestMethodContextBuilder(Object servlet, Method method, RestContext context) throws RestServletException {
        this.context = context;
        this.method = method;
        String sig = method.getDeclaringClass().getName() + '.' + method.getName();
        MethodInfo mi = MethodInfo.of(servlet.getClass(), method, method);
        try {
            RestMethod m = mi.getAnnotation(RestMethod.class);
            if (m == null) {
                throw new RestServletException("@RestMethod annotation not found on method ''{0}''", sig);
            }
            VarResolver vr = context.getVarResolver();
            VarResolverSession vrs = vr.createSession();
            this.applyAnnotations(mi.getAnnotationListParentFirst(ConfigAnnotationFilter.INSTANCE), vrs);
            this.properties = new RestMethodProperties(context.getProperties());
            if (m.properties().length > 0 || m.flags().length > 0) {
                this.properties = new RestMethodProperties(this.properties);
                for (Property property : m.properties()) {
                    this.properties.put(property.name(), property.value());
                }
                for (String string : m.flags()) {
                    this.properties.put(string, true);
                }
            }
        }
        catch (RestServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestServletException("Exception occurred while initializing method ''{0}''", sig).initCause(e);
        }
    }
}

