/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.websockets;

import com.nimbusds.jose.JWSHeader;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.provider.federation.jwt.filter.SignatureVerificationCache;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.util.Tokens;

public class JWTValidator {
    private static final String JWT_DEFAULT_ISSUER = "KNOXSSO";
    private static final String JWT_DEFAULT_SIGALG = "RS256";
    private static final JWTMessages jwtMessagesLog = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    private final JWTokenAuthority authorityService;
    private final SignatureVerificationCache signatureVerificationCache;
    private final JWT token;
    private String expectedIssuer = "KNOXSSO";
    private String expectedSigAlg = "RS256";
    private RSAPublicKey publicKey;
    private TokenStateService tokenStateService;
    private final String displayableTokenId;
    private final String displayableToken;

    public JWTValidator(JWT token, JWTokenAuthority authorityService, SignatureVerificationCache signatureVerificationCache) {
        this.authorityService = authorityService;
        this.signatureVerificationCache = signatureVerificationCache;
        this.token = token;
        this.displayableTokenId = Tokens.getTokenIDDisplayText((String)TokenUtils.getTokenId((JWT)token));
        this.displayableToken = Tokens.getTokenDisplayText((String)token.toString());
    }

    public void setPublicKey(RSAPublicKey val) {
        this.publicKey = val;
    }

    public void setExpectedSigAlg(String val) {
        this.expectedSigAlg = val;
    }

    public void setExpectedIssuer(String val) {
        this.expectedIssuer = val;
    }

    public void setTokenStateService(TokenStateService val) {
        this.tokenStateService = val;
    }

    public JWT getToken() {
        return this.token;
    }

    public String getUsername() {
        return this.token.getSubject();
    }

    public boolean validate() {
        if (this.expectedIssuer.equals(this.token.getIssuer())) {
            try {
                if (this.tokenIsStillValid()) {
                    Date nbf = this.token.getNotBeforeDate();
                    if (nbf == null || new Date().after(nbf)) {
                        if (this.isTokenEnabled() && this.verifyTokenSignature()) {
                            return true;
                        }
                    } else {
                        jwtMessagesLog.notBeforeCheckFailed();
                    }
                }
            }
            catch (UnknownTokenException e) {
                return false;
            }
        }
        jwtMessagesLog.unexpectedTokenIssuer(this.displayableToken, this.displayableTokenId);
        return false;
    }

    public boolean tokenIsStillValid() throws UnknownTokenException {
        Date expires = this.getServerManagedStateExpiration();
        if (expires == null) {
            expires = this.token.getExpiresDate();
        }
        if (expires == null || new Date().before(expires)) {
            return true;
        }
        jwtMessagesLog.tokenHasExpired(this.displayableToken, this.displayableTokenId);
        this.signatureVerificationCache.removeSignatureVerificationRecord(this.token.toString());
        return false;
    }

    private Date getServerManagedStateExpiration() throws UnknownTokenException {
        long value;
        Date expires = null;
        if (this.tokenStateService != null && (value = this.tokenStateService.getTokenExpiration(TokenUtils.getTokenId((JWT)this.token))) > 0L) {
            expires = new Date(value);
        }
        return expires;
    }

    private boolean isTokenEnabled() throws UnknownTokenException {
        TokenMetadata tokenMetadata;
        TokenMetadata tokenMetadata2 = tokenMetadata = this.tokenStateService == null ? null : this.tokenStateService.getTokenMetadata(TokenUtils.getTokenId((JWT)this.token));
        if (tokenMetadata == null || tokenMetadata.isEnabled()) {
            return true;
        }
        jwtMessagesLog.disabledToken(this.displayableTokenId);
        return false;
    }

    private boolean verifyTokenSignature() {
        String serializedJWT = this.token.toString();
        boolean verified = this.signatureVerificationCache.hasSignatureBeenVerified(serializedJWT);
        if (!verified) {
            try {
                verified = this.publicKey != null ? this.authorityService.verifyToken(this.token, this.publicKey) : this.authorityService.verifyToken(this.token);
            }
            catch (TokenServiceException e) {
                jwtMessagesLog.unableToVerifyToken((Exception)((Object)e));
            }
            if (verified && this.expectedSigAlg != null) {
                try {
                    String receivedSigAlg = JWSHeader.parse((String)this.token.getHeader()).getAlgorithm().getName();
                    if (!receivedSigAlg.equals(this.expectedSigAlg)) {
                        verified = false;
                    }
                }
                catch (ParseException e) {
                    jwtMessagesLog.unableToVerifyToken((Exception)e);
                    verified = false;
                }
            }
            if (verified) {
                this.signatureVerificationCache.recordSignatureVerification(serializedJWT);
            }
        }
        if (!verified) {
            jwtMessagesLog.failedToVerifyTokenSignature(this.displayableToken, this.displayableTokenId);
        }
        return verified;
    }
}

