/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package net.java.html.json;

import org.testng.Assert;
import org.testng.annotations.Test;

@Model(className = "VarArg", instance = true, properties = {
})
public class VarArgTest {
    @ModelOperation
    void read(VarArg square, VarArgTest[] arr) {
        Assert.assertNotNull(arr, "Array passed in");
        Assert.assertEquals(arr.length, 1, "One slot ready");
        arr[0] = this;
    }

    @Test
    public void canReadThis() {
        VarArgTest[] arr = { null };
        VarArg model = new VarArg();
        model.read(arr);
        Assert.assertNotNull(arr[0]);
    }
}
