/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryBuilder;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefDatabase;

public class InMemoryRepository
extends DfsRepository {
    static final AtomicInteger packId = new AtomicInteger();
    private final MemObjDatabase objdb = new MemObjDatabase(this);
    private final MemRefDatabase refdb = this.createRefDatabase();
    private String gitwebDescription;

    public InMemoryRepository(DfsRepositoryDescription repoDesc) {
        this((Builder)new Builder().setRepositoryDescription(repoDesc));
    }

    InMemoryRepository(Builder builder) {
        super(builder);
    }

    protected MemRefDatabase createRefDatabase() {
        return new MemRefDatabase();
    }

    @Override
    public MemObjDatabase getObjectDatabase() {
        return this.objdb;
    }

    @Override
    public RefDatabase getRefDatabase() {
        return this.refdb;
    }

    public void setPerformsAtomicTransactions(boolean atomic) {
        this.refdb.performsAtomicTransactions = atomic;
    }

    @Override
    @Nullable
    public String getGitwebDescription() {
        return this.gitwebDescription;
    }

    @Override
    public void setGitwebDescription(@Nullable String d) {
        this.gitwebDescription = d;
    }

    public static class Builder
    extends DfsRepositoryBuilder<Builder, InMemoryRepository> {
        @Override
        public InMemoryRepository build() throws IOException {
            return new InMemoryRepository(this);
        }
    }

    private static class ByteArrayReadableChannel
    implements ReadableChannel {
        private final byte[] data;
        private final int blockSize;
        private int position;
        private boolean open = true;

        ByteArrayReadableChannel(byte[] buf, int blockSize) {
            this.data = buf;
            this.blockSize = blockSize;
        }

        @Override
        public int read(ByteBuffer dst) {
            int n = Math.min(dst.remaining(), this.data.length - this.position);
            if (n == 0) {
                return -1;
            }
            dst.put(this.data, this.position, n);
            this.position += n;
            return n;
        }

        @Override
        public void close() {
            this.open = false;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public long position() {
            return this.position;
        }

        @Override
        public void position(long newPosition) {
            this.position = (int)newPosition;
        }

        @Override
        public long size() {
            return this.data.length;
        }

        @Override
        public int blockSize() {
            return this.blockSize;
        }

        @Override
        public void setReadAheadBytes(int b) {
        }
    }

    public static class MemObjDatabase
    extends DfsObjDatabase {
        private List<DfsPackDescription> packs = new ArrayList<DfsPackDescription>();
        private int blockSize;
        private Set<ObjectId> shallowCommits = Collections.emptySet();

        MemObjDatabase(DfsRepository repo) {
            super(repo, new DfsReaderOptions());
        }

        public void setReadableChannelBlockSizeForTest(int blockSize) {
            this.blockSize = blockSize;
        }

        @Override
        protected synchronized List<DfsPackDescription> listPacks() {
            return this.packs;
        }

        @Override
        protected DfsPackDescription newPack(DfsObjDatabase.PackSource source) {
            int id = packId.incrementAndGet();
            return new MemPack("pack-" + id + "-" + source.name(), this.getRepository().getDescription(), source);
        }

        @Override
        protected synchronized void commitPackImpl(Collection<DfsPackDescription> desc, Collection<DfsPackDescription> replace) {
            ArrayList<DfsPackDescription> n = new ArrayList<DfsPackDescription>(desc.size() + this.packs.size());
            n.addAll(desc);
            n.addAll(this.packs);
            if (replace != null) {
                n.removeAll(replace);
            }
            this.packs = n;
            this.clearCache();
        }

        @Override
        protected void rollbackPack(Collection<DfsPackDescription> desc) {
        }

        @Override
        protected ReadableChannel openFile(DfsPackDescription desc, PackExt ext) throws FileNotFoundException, IOException {
            MemPack memPack = (MemPack)desc;
            byte[] file = memPack.get(ext);
            if (file == null) {
                throw new FileNotFoundException(desc.getFileName(ext));
            }
            return new ByteArrayReadableChannel(file, this.blockSize);
        }

        @Override
        protected DfsOutputStream writeFile(DfsPackDescription desc, final PackExt ext) throws IOException {
            final MemPack memPack = (MemPack)desc;
            return new Out(){

                @Override
                public void flush() {
                    memPack.put(ext, this.getData());
                }
            };
        }

        @Override
        public Set<ObjectId> getShallowCommits() throws IOException {
            return this.shallowCommits;
        }

        @Override
        public void setShallowCommits(Set<ObjectId> shallowCommits) {
            this.shallowCommits = shallowCommits;
        }

        @Override
        public long getApproximateObjectCount() {
            long count = 0L;
            for (DfsPackDescription p : this.packs) {
                count += p.getObjectCount();
            }
            return count;
        }
    }

    private static class MemPack
    extends DfsPackDescription {
        final byte[][] fileMap = new byte[PackExt.values().length][];

        MemPack(String name, DfsRepositoryDescription repoDesc, DfsObjDatabase.PackSource source) {
            super(repoDesc, name, source);
        }

        void put(PackExt ext, byte[] data) {
            this.fileMap[ext.getPosition()] = data;
        }

        byte[] get(PackExt ext) {
            return this.fileMap[ext.getPosition()];
        }
    }

    protected class MemRefDatabase
    extends DfsReftableDatabase {
        boolean performsAtomicTransactions;

        protected MemRefDatabase() {
            super(InMemoryRepository.this);
            this.performsAtomicTransactions = true;
        }

        @Override
        public ReftableConfig getReftableConfig() {
            ReftableConfig cfg = new ReftableConfig();
            cfg.setAlignBlocks(false);
            cfg.setIndexObjects(false);
            cfg.fromConfig(this.getRepository().getConfig());
            return cfg;
        }

        @Override
        public boolean performsAtomicTransactions() {
            return this.performsAtomicTransactions;
        }
    }

    private static abstract class Out
    extends DfsOutputStream {
        private final ByteArrayOutputStream dst = new ByteArrayOutputStream();
        private byte[] data;

        private Out() {
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.data = null;
            this.dst.write(buf, off, len);
        }

        @Override
        public int read(long position, ByteBuffer buf) {
            byte[] d = this.getData();
            int n = Math.min(buf.remaining(), d.length - (int)position);
            if (n == 0) {
                return -1;
            }
            buf.put(d, (int)position, n);
            return n;
        }

        byte[] getData() {
            if (this.data == null) {
                this.data = this.dst.toByteArray();
            }
            return this.data;
        }

        @Override
        public abstract void flush();

        @Override
        public void close() {
            this.flush();
        }
    }
}

