/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.repository.aot.generate.AotFragmentTarget;
import org.springframework.data.repository.aot.generate.JSONException;
import org.springframework.data.repository.aot.generate.JSONObject;
import org.springframework.data.repository.aot.generate.QueryMetadata;

public record AotRepositoryMethod(String name, String signature, @Nullable QueryMetadata query, @Nullable AotFragmentTarget fragment) {
    public JSONObject toJson() throws JSONException {
        JSONObject method = new JSONObject();
        method.put("name", this.name());
        method.put("signature", this.signature());
        if (this.query() != null) {
            method.put("query", AotRepositoryMethod.queryMetadataToJson(this.query()));
        } else if (this.fragment() != null) {
            method.put("fragment", this.fragment().toJson());
        }
        return method;
    }

    static JSONObject queryMetadataToJson(QueryMetadata queryMetadata) throws JSONException {
        JSONObject query = new JSONObject();
        for (Map.Entry<String, Object> entry : queryMetadata.serialize().entrySet()) {
            query.put(entry.getKey(), JSONObject.wrap(entry.getValue()));
        }
        return query;
    }
}

