/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.archive.util.InterruptibleCharSequence;

public class TextUtils {
    private static final String FIRSTWORD = "^([^\\s]*).*$";
    private static final ThreadLocal<Map<String, Matcher>> TL_MATCHER_MAP = new ThreadLocal<Map<String, Matcher>>(){

        @Override
        protected Map<String, Matcher> initialValue() {
            return new HashMap<String, Matcher>(50);
        }
    };
    private static final LoadingCache<String, Pattern> PATTERNS = CacheBuilder.newBuilder().concurrencyLevel(16).softValues().build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String regex) {
            return Pattern.compile(regex);
        }
    });

    public static Matcher getMatcher(String pattern, CharSequence input) {
        if (pattern == null) {
            throw new IllegalArgumentException("String 'pattern' must not be null");
        }
        input = new InterruptibleCharSequence(input);
        Map<String, Matcher> matchers = TL_MATCHER_MAP.get();
        Matcher m = matchers.get(pattern);
        if (m == null) {
            m = ((Pattern)PATTERNS.getUnchecked((Object)pattern)).matcher(input);
        } else {
            matchers.put(pattern, null);
            m.reset(input);
        }
        return m;
    }

    public static void recycleMatcher(Matcher m) {
        m.reset("");
        Map<String, Matcher> matchers = TL_MATCHER_MAP.get();
        matchers.put(m.pattern().pattern(), m);
    }

    public static String replaceAll(String pattern, CharSequence input, String replacement) {
        input = new InterruptibleCharSequence(input);
        Matcher m = TextUtils.getMatcher(pattern, input);
        String res = m.replaceAll(replacement);
        TextUtils.recycleMatcher(m);
        return res;
    }

    public static String replaceFirst(String pattern, CharSequence input, String replacement) {
        input = new InterruptibleCharSequence(input);
        Matcher m = TextUtils.getMatcher(pattern, input);
        String res = m.replaceFirst(replacement);
        TextUtils.recycleMatcher(m);
        return res;
    }

    public static boolean matches(String pattern, CharSequence input) {
        input = new InterruptibleCharSequence(input);
        Matcher m = TextUtils.getMatcher(pattern, input);
        boolean res = m.matches();
        TextUtils.recycleMatcher(m);
        return res;
    }

    public static String[] split(String pattern, CharSequence input) {
        input = new InterruptibleCharSequence(input);
        Matcher m = TextUtils.getMatcher(pattern, input);
        String[] retVal = m.pattern().split(input);
        TextUtils.recycleMatcher(m);
        return retVal;
    }

    public static String getFirstWord(String s) {
        Matcher m = TextUtils.getMatcher(FIRSTWORD, s);
        String retVal = m != null && m.matches() ? m.group(1) : null;
        TextUtils.recycleMatcher(m);
        return retVal;
    }

    public static String escapeForHTMLJavascript(String s) {
        return TextUtils.escapeForHTML(StringEscapeUtils.escapeEcmaScript((String)s));
    }

    public static String escapeForMarkupAttribute(String s) {
        return StringEscapeUtils.escapeXml((String)s);
    }

    public static String escapeForHTML(String s) {
        String escaped = s.replaceAll("&", "&amp;");
        return escaped.replaceAll("<", "&lt;");
    }

    public static void writeEscapedForHTML(String s, Writer w) throws IOException {
        String line;
        PrintWriter out = new PrintWriter(w);
        BufferedReader reader = new BufferedReader(new StringReader(s));
        while ((line = reader.readLine()) != null) {
            out.println(StringEscapeUtils.escapeHtml3((String)line));
        }
    }

    public static CharSequence unescapeHtml(CharSequence cs) {
        if (cs == null) {
            return cs;
        }
        return StringEscapeUtils.unescapeHtml4((String)cs.toString());
    }

    public static String exceptionToString(String message, Throwable e) {
        StringWriter sw = new StringWriter();
        if (message == null || message.length() == 0) {
            sw.write(message);
            sw.write("\n");
        }
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String urlEscape(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static String urlUnescape(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

